/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgStudentCourse>
implements OrgStudentCourseDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCourseDaoImpl.class);

    public OrgStudentCourseDaoImpl() {
        super(OrgStudentCourse.class);
    }

    @Override
    public List<Long> getStudents(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public OrgStudentCourse getStudentCourse(@NonNull Long orgId, @NonNull Long courseId, @NonNull Long userId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        return (OrgStudentCourse)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudentCourse> getStudentListByCourseId(Long orgId, Long courseId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.add(Expressions.or((Expression)Expressions.eq((String)"orgId", (Serializable)orgId), (Expression)Expressions.eq((String)"orgId", (Serializable)Integer.valueOf(0))));
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.select(queryProps);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getStudentListByCourseId(Long orgId, Long courseId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.add(Expressions.or((Expression)Expressions.eq((String)"orgId", (Serializable)orgId), (Expression)Expressions.eq((String)"orgId", (Serializable)Integer.valueOf(0))));
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.desc("createTime");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public void deleteOrgCourseStudent(Long orgId, Long courseId, Long userId, Integer status) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseId);
        condition.put("userId", userId);
        OrgStudentCourse obj = new OrgStudentCourse();
        obj.setStatus(status);
        this.update(condition, (Object)obj, new String[]{"status"});
    }

    @Override
    public void batchDeleteOrgCourseStudent(Long orgId, Long courseId, Collection<Long> userIds, Integer status) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseId);
        condition.put("userId", userIds);
        OrgStudentCourse obj = new OrgStudentCourse();
        obj.setStatus(status);
        this.update(condition, (Object)obj, new String[]{"status"});
    }

    @Override
    public List<OrgStudentCourse> getStudentListByStudentId(Long userId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        builder.select(queryProps);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<OrgStudentCourse>> getStudentMapBycourseIds(Collection<Long> courseIds, final String ... queryProps) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.select(queryProps);
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgStudentCourse orgStudentCourse : courses) {
            List orgStudentCourses = (List)map.get(orgStudentCourse.getCourseId());
            if (orgStudentCourses == null) {
                orgStudentCourses = Lists.newArrayList();
                map.put(orgStudentCourse.getCourseId(), orgStudentCourses);
            }
            orgStudentCourses.add(orgStudentCourse);
        }
        return map;
    }

    @Override
    public Map<Long, List<OrgStudentCourse>> getStudentMapBycourseIds(Collection<Long> courseIds, final int status, final String ... queryProps) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("status", (Serializable)Integer.valueOf(status));
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.select(queryProps);
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgStudentCourse orgStudentCourse : courses) {
            List orgStudentCourses = (List)map.get(orgStudentCourse.getCourseId());
            if (orgStudentCourses == null) {
                orgStudentCourses = Lists.newArrayList();
                map.put(orgStudentCourse.getCourseId(), orgStudentCourses);
            }
            orgStudentCourses.add(orgStudentCourse);
        }
        return map;
    }

    @Override
    public Map<Long, List<OrgStudentCourse>> getStudentMapToRealCourseIds(Collection<Long> courseIds, final int status, final String ... queryProps) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("realCourseId", querySet);
                builder.eq("status", (Serializable)Integer.valueOf(status));
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.select(queryProps);
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgStudentCourse orgStudentCourse : courses) {
            List orgStudentCourses = (List)map.get(orgStudentCourse.getRealCourseId());
            if (orgStudentCourses == null) {
                orgStudentCourses = Lists.newArrayList();
                map.put(orgStudentCourse.getRealCourseId(), orgStudentCourses);
            }
            orgStudentCourses.add(orgStudentCourse);
        }
        return map;
    }

    @Override
    public Map<Long, List<Long>> getStudentIdMapBycourseIds(Collection<Long> courseIds, final Long orgId) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.eq("status", (Serializable)Integer.valueOf(0));
                builder.eq("orgId", (Serializable)orgId);
                builder.select(new String[]{"courseId", "userId"});
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)courses, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getCourseId();
            }
        }, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getStudentIdMapBycourseIdsNoStatus(Collection<Long> courseIds, final Long orgId) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.eq("orgId", (Serializable)orgId);
                builder.select(new String[]{"courseId", "userId"});
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)courses, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getCourseId();
            }
        }, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getCourseIdMapByStuIds(Collection<Long> stuIds, final Long orgId) {
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List courses = (List)batchQueryTemplate.batchQuery(stuIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentCourse>>(){

            public List<OrgStudentCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("status", (Serializable)Integer.valueOf(0));
                builder.select(new String[]{"courseId", "userId"});
                return OrgStudentCourseDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)courses, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgStudentCourse, Long>(){

            public Long apply(OrgStudentCourse arg0) {
                return arg0.getCourseId();
            }
        });
    }

    @Override
    public Map<Long, Integer> getCurStudentCntByCourseIds(final Long orgId, Collection<Long> courseIds, String ... queryProps) {
        MapBatchQueryTemplate batchTemplate = new MapBatchQueryTemplate();
        return (Map)batchTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.count("id");
                builder.add(Expressions.or((Expression)Expressions.eq((String)"orgId", (Serializable)orgId), (Expression)Expressions.eq((String)"orgId", (Serializable)Integer.valueOf(0))));
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.group("courseId");
                builder.in("courseId", querySet);
                List queryList = OrgStudentCourseDaoImpl.this.query2ListMap(builder);
                if (CollectionUtils.isNotEmpty((Collection)queryList)) {
                    HashMap result = Maps.newHashMap();
                    for (Map objMap : queryList) {
                        result.put(((Number)objMap.get("courseId")).longValue(), ((Number)objMap.get("cnt_id")).intValue());
                    }
                    return result;
                }
                return Collections.emptyMap();
            }
        });
    }

    @Override
    public void updateStudentName(Long userId, String studentName) {
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.put("studentName", studentName);
        this.getNamedJdbcTemplate().update("update tts.org_student_course set student_name = :studentName where student_id = :userId", (Map)params);
    }

    @Override
    public List<Long> getOrgCourseIds(Long orgId, List<Long> courseIds, boolean ascByStuCnt, PageDto pageDto) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.count("id", "cnt");
        builder.in("courseId", courseIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)Integer.valueOf(0));
        builder.eq("tradeComplete", (Serializable)Integer.valueOf(1));
        builder.group("courseId");
        if (ascByStuCnt) {
            builder.asc("cnt");
        } else {
            builder.desc("cnt");
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudents(Long orgId, Long courseId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)status);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, Integer> getStudentCount(Long orgId, Collection<Long> courseIds) {
        return this.getStudentCount(orgId, courseIds, null);
    }

    @Override
    public Map<Long, Integer> getStudentCount(final Long orgId, Collection<Long> courseIds, final Boolean tradeComplete) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.eq("status", (Serializable)Integer.valueOf(0));
                if (tradeComplete != null) {
                    builder.eq("tradeComplete", (Serializable)Integer.valueOf(tradeComplete != false ? 1 : 0));
                }
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgStudentCourseDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getStudentCountNoStatus(final Long orgId, Collection<Long> courseIds, final Boolean tradeComplete) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                if (tradeComplete != null) {
                    builder.eq("tradeComplete", (Serializable)Integer.valueOf(tradeComplete != false ? 1 : 0));
                }
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgStudentCourseDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, Integer status, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.asc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, PageDto pageDto) {
        return this.getOrgCourseIds(orgId, userId, StudentCourseStatus.NORMAL.getCode(), pageDto);
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseByOrgId(Long orgId, Collection<Long> courseIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (courseIds != null && !courseIds.isEmpty()) {
            builder.in("courseId", courseIds);
        }
        builder.group("courseId");
        builder.desc("createTime");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getOrgCourseByOrgIdAndIds(Long orgId, Collection<Long> courseIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.in("courseId", courseIds);
        builder.eq("status", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentCourseCount(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getStudentSignupCourseCount(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.distinctCount("courseId");
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getStudentCourseIds(Long orgId, Long userId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudentCourseIdsByStatus(Long orgId, Long userId, List<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId"});
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.in("status", status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getStudentIdsByCourseIds(final Long orgId, Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                return OrgStudentCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<Long> getStudentIdsByCourseIdsWithStatus(final Long orgId, Collection<Long> courseIds, final Integer status) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("status", (Serializable)status);
                builder.in("courseId", querySet);
                return OrgStudentCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public void refreshOrgStudentCourse(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_student_course set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public void deleteByOrgCourseId(Integer orgId, Integer courseId) {
        StringBuilder sb = new StringBuilder("update tts.org_student_course set del_status =1 where course_id = :courseId and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("courseId", courseId);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<Long> getEnrollClassUserIdByUserIds(final Long orgId, Collection<Long> userIds) {
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentCourseDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.eq("orgId", (Serializable)orgId);
                builder.in("userId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.group("userId");
                return OrgStudentCourseDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public Map<Integer, Integer> allCourseOrgIdMap() {
        HashMap param = new HashMap();
        String sql = "select org_id,course_id from tts.org_student_course where course_id <= 46763 and course_id>0 and org_id>0 and del_status=0  group by org_id,course_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, Integer>>(){

            public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    Integer courseId = rs.getInt("course_id");
                    Integer orgId = rs.getInt("org_id");
                    map.put(courseId, orgId);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgStudentCourse> getOrgStudentCourseByUserIds(Long orgId, Collection<Long> userIds, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (userIds != null && userIds.size() > 0) {
            builder.in("userId", userIds);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> searchStudentWithCourseIds(Long orgId, Set<Long> filterIds, List<Long> noDelCourseIds, boolean allCourse) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)Integer.valueOf(0));
        log.info("orgId:{} , filterIds:{} , noDelCourseIds:{} ,allCourse:{}", new Object[]{orgId, filterIds, noDelCourseIds, allCourse});
        if (allCourse) {
            noDelCourseIds.removeAll(filterIds);
            if (GenericsUtils.notNullAndEmpty(noDelCourseIds)) {
                builder.in("courseId", noDelCourseIds);
            }
        } else {
            filterIds.retainAll(noDelCourseIds);
            if (GenericsUtils.isNullOrEmpty(filterIds)) {
                return Collections.emptyList();
            }
            builder.in("courseId", filterIds);
        }
        log.info("sql is : {} ", (Object)builder.toSql());
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getOrgStudentCourseByOrgIds(Collection<Long> orgIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Long>> getOrgCourseIdMap(long orgId, Set<Long> userIds) {
        List<OrgStudentCourse> orgStudentCourseByUserIds = this.getOrgStudentCourseByUserIds(orgId, userIds, "userId", "courseId");
        Map emptyMap = GenericsUtils.emptyMap();
        if (GenericsUtils.isNullOrEmpty(orgStudentCourseByUserIds)) {
            return emptyMap;
        }
        for (OrgStudentCourse osc : orgStudentCourseByUserIds) {
            Long studentId = osc.getUserId();
            GenericsUtils.addListIfNotExists((Map)emptyMap, (Object)studentId, (Object)osc.getCourseId());
        }
        return emptyMap;
    }

    @Override
    public int sumOneToOneClassHours(Collection<Long> classIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("courseId", classIds);
        builder.sum("lessonCount");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<StudentClassHourStatusDocument> searchStudentClassHourStatus(Set<Long> userIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseId", "userId", "status", "lessonCount", "chargeUnit"});
        builder.eq("orgId", (Serializable)orgId);
        builder.in("userId", userIds);
        List queryList = this.queryList(builder);
        ArrayList ret = Lists.newArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)queryList)) {
            for (OrgStudentCourse osc : queryList) {
                StudentClassHourStatusDocument scsd = new StudentClassHourStatusDocument();
                scsd.setCourseId(osc.getCourseId());
                scsd.setLessonCount(osc.getLessonCount());
                scsd.setStatus(osc.getStatus());
                scsd.setUserId(osc.getUserId());
                scsd.setOrgId(orgId);
                scsd.setChargeUnit(osc.getChargeUnit());
                ret.add(scsd);
            }
        }
        return ret;
    }

    @Override
    public List<OrgStudentCourse> getPageByCourseIdAndMaxId(Long orgId, Long courseId, Integer limit, Long maxId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        if (maxId != null) {
            builder.gt("id", (Serializable)maxId);
        }
        builder.addOrder(Order.asc((String[])new String[]{"id"}));
        builder.setMaxSize(limit);
        return this.queryList(builder);
    }

    @Override
    public OrgStudentCourse getByStudentAndClassId(Long orgId, Long userId, Collection<Long> classIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.in("courseId", classIds);
        builder.eq("status", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        builder.desc("id");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudentCourse)((Object)this.uniqueResult(builder));
    }

    @Override
    public OrgStudentCourse getStudentCourseByRealCourseId(Long orgId, Long realCourseId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("realCourseId", (Serializable)realCourseId);
        builder.desc("id");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudentCourse)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudentCourse> getByCourseIdsStudentId(Long orgId, Collection<Long> courseIds, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        builder.eq("status", (Serializable)Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getByCourseIdsStudentId(Long orgId, Collection<Long> courseIds, Collection<Long> userIds, Integer status, Integer delStatus) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (null != status) {
            builder.eq("status", (Serializable)status);
        }
        if (null != delStatus) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getStudentCourseByStuNameAndMobile(Long orgId, String studentName, String mobile, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)studentName)) {
            builder.like("studentName", (Serializable)((Object)studentName), MatchMode.ANYWHERE);
        }
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            builder.like("mobile", (Serializable)((Object)mobile), MatchMode.ANYWHERE);
        }
        builder.eq("status", (Serializable)Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> getBetweenId(@NonNull Integer startId, @NonNull Integer endId, List<Long> orgIds, Integer status, Integer delStatus, String ... props) {
        if (startId == null) {
            throw new NullPointerException("startId");
        }
        if (endId == null) {
            throw new NullPointerException("endId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.ge("id", (Serializable)startId);
        builder.lt("id", (Serializable)endId);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.in("orgId", orgIds);
        }
        if (null != status) {
            builder.eq("status", (Serializable)status);
        }
        if (null != delStatus) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> listByCourseId(Long orgId, Long courseId, Integer status, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> listByStudentUserId(Long orgId, Long userId, Integer status, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> listByUserId(Long orgId, Long userId, Collection<Long> courseIds, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> listByOrgId(Long orgId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer countStudents(Long orgId, Long courseId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.eq("courseId", (Serializable)courseId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> listReClassId(Long orgId, Long courseId, Integer status) {
        return null;
    }

    @Override
    public List<Long> listStudentUserIdsByCourseIds(Long orgId, Long courseId) {
        final ArrayList<Long> result = new ArrayList<Long>();
        String sql = "SELECT student_id FROM tts.org_student_course WHERE course_id=:courseId";
        if (orgId != null) {
            sql = sql + " AND org_id=:orgId";
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", orgId);
        params.put("courseId", courseId);
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("student_id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public OrgStudentCourse listByCourseIdAndUserId(Long orgId, Long courseId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("courseId", (Serializable)courseId);
        builder.desc("id");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudentCourse)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudentCourse> listAllNeedSyncRecord(long lastRecordId, Integer maxSize, Long ... limitOrgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "courseId", "userId", "realCourseId"});
        builder.gt("id", (Serializable)Long.valueOf(lastRecordId));
        if (GenericsUtils.notNullAndEmpty((Object)limitOrgIds)) {
            builder.in("orgId", Arrays.asList(limitOrgIds));
        }
        builder.asc("id");
        builder.setMaxSize(maxSize);
        log.info("sql is:{} ,lastRecordId {}", (Object)builder.toSql(), (Object)lastRecordId);
        List retList = this.queryList(builder);
        log.info("retList's size is{}", (Object)retList.size());
        return retList;
    }

    @Override
    public List<OrgStudentCourse> listAllNeedSyncRecordWithRange(long firstId, long lastId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "courseId", "userId", "realCourseId"});
        builder.gt("id", (Serializable)Long.valueOf(firstId));
        builder.le("id", (Serializable)Long.valueOf(lastId));
        builder.asc("id");
        builder.setMaxSize(Integer.valueOf(5000));
        log.info("sql is:{} ,lastRecordId {} and firstId :{} and lastId:{} ", new Object[]{builder.toSql(), firstId, lastId});
        List retList = this.queryList(builder);
        log.info("retList's size is{}", (Object)retList.size());
        return retList;
    }

    @Override
    public Map<Long, Integer> userMapByStatus(Long orgId, Long classId, Collection<Long> userIds, Collection<Integer> status) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"status", "userId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)classId);
        builder.in("userId", userIds);
        builder.in("status", status);
        log.debug("sql:{}, params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        HashMap result = Maps.newHashMap();
        for (OrgStudentCourse course : this.queryList(builder)) {
            result.put(course.getUserId(), course.getStatus());
        }
        return result;
    }

    @Override
    public List<OrgStudentCourse> listByStatus(Long orgId, Long classId, Collection<Long> userIds, Collection<Integer> status, String ... prop) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(prop);
        builder.eq("orgId", (Serializable)orgId);
        if (null != classId) {
            builder.eq("courseId", (Serializable)classId);
        }
        builder.in("userId", userIds);
        builder.in("status", status);
        return this.queryList(builder);
    }

    @Override
    public List<Long> selectOneToOneClassId(Long orgId) {
        String sql = "select course_id from tts.org_student_course where org_id=:orgId and course_id != real_course_id";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orgId", orgId);
        return this.getNamedJdbcTemplate().queryForList(sql, map, Long.class);
    }

    @Override
    public List<OrgStudentCourse> getNoRealCourseIdData() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("realCourseId", (Serializable)Integer.valueOf(0));
        builder.ne("courseId", (Serializable)Integer.valueOf(0));
        builder.setMaxSize(Integer.valueOf(50));
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> mapStudentCount(Collection<Long> classIds) {
        if (CollectionUtils.isEmpty(classIds)) {
            return Maps.newHashMap();
        }
        final HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        String sql = "SELECT course_id,count(id) AS stuNum FROM tts.org_student_course WHERE status=0 AND del_status=0 AND course_id IN (:classIds) GROUP BY course_id";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("classIds", classIds);
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("course_id"), rs.getInt("stuNum"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<Long>> mapCourseIdStuList(Collection<Long> classIds) {
        final HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        if (CollectionUtils.isEmpty(classIds)) {
            return result;
        }
        String sql = "SELECT course_id,student_id FROM tts.org_student_course WHERE course_id IN (:classIds)";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("classIds", classIds);
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                Long courseId = rs.getLong("course_id");
                Long studentId = rs.getLong("student_id");
                if (result.get(courseId) == null) {
                    result.put(courseId, new ArrayList());
                }
                ((List)result.get(courseId)).add(studentId);
                return 1;
            }
        });
        return result;
    }

    @Override
    public int selectMaxId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgStudentCourse> listByCourseIdsAndUserIds(Set<Long> orgIds, Set<Long> courseIds, Set<Long> userIds) {
        log.info("Param=orgIds={},courseIds={},userIds={}");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (GenericsUtils.isNullOrEmpty(orgIds) || GenericsUtils.isNullOrEmpty(courseIds) || GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        builder.in("orgId", orgIds);
        if (userIds != null && userIds.size() > 0) {
            builder.in("userId", userIds);
        }
        builder.in("realCourseId", courseIds);
        log.info("sql is :{} ", (Object)builder.toSql());
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudentCourse> listOrderByName(Long courseId, Collection<Long> userIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("userId", userIds);
        builder.eq("courseId", (Serializable)courseId);
        builder.asc("studentName");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Set<Long> listStudentUserIdsByCourseIds(Long orgId, List<Long> ownCourseIds, Integer status) {
        if (GenericsUtils.isNullOrEmpty(ownCourseIds)) {
            return GenericsUtils.emptySet();
        }
        final HashSet result = Sets.newHashSet();
        String sql = "SELECT student_id FROM tts.org_student_course WHERE course_id in(:courseId) and del_status = 0";
        if (orgId != null) {
            sql = sql + " AND org_id=:orgId";
        }
        if (status != null) {
            sql = sql + " AND status = :status ";
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("courseId", ownCourseIds);
        if (status != null) {
            params.put("status", status);
        }
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("student_id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgStudentCourse> listByUserIds(@NonNull Long orgId, @NonNull Collection<Long> userIds, Integer status) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (userIds == null) {
            throw new NullPointerException("userIds");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("userId", userIds);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<String> listMultiClass() {
        String sql = "select count(1) as c,student_id,real_course_id,org_id from (select student_id,course_id,real_course_id,org_id from tts.org_student_course group by student_id,course_id,real_course_id,org_id) tmp group by student_id,real_course_id,org_id having c>1";
        return this.getNamedJdbcTemplate().query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet resultSet, int i) throws SQLException {
                int count = resultSet.getInt("c");
                long studentId = resultSet.getLong("student_id");
                long courseId = resultSet.getLong("real_course_id");
                long orgId = resultSet.getLong("org_id");
                return orgId + "_" + studentId + "_" + courseId + "_" + count;
            }
        });
    }

    @Override
    public List<OrgStudentCourse> listByTimeRange(Long orgId, Integer status, Date startTime, Date endTime, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryList(builder);
    }
}

