/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseKexiaoDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseKexiao;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseKexiaoDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseKexiao>
implements OrgCourseKexiaoDao {
    @Override
    public long getIncome(Date start, Date end, List<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return -1L;
        }
        StringBuilder sql = new StringBuilder("select sum(kexiao) as income from yunying.org_course_kexiao where create_time >= :start and create_time < :end and course_id in (:courseIds)");
        HashMap param = Maps.newHashMap();
        param.put("start", start);
        param.put("end", end);
        param.put("courseIds", courseIds);
        List income = this.getNamedJdbcTemplate().query(sql.toString(), (Map)param, (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet resultSet, int i) throws SQLException {
                long income = resultSet.getLong("income");
                return income;
            }
        });
        return (Long)income.get(0);
    }

    @Override
    public long getSchoolIncome(Date start, Date end, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return -1L;
        }
        StringBuilder sql = new StringBuilder("select sum(kexiao) as income from yunying.org_course_kexiao where create_time >= :start and create_time < :end and org_id in (:orgIds)");
        HashMap param = Maps.newHashMap();
        param.put("start", start);
        param.put("end", end);
        param.put("orgIds", orgIds);
        List income = this.getNamedJdbcTemplate().query(sql.toString(), (Map)param, (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet resultSet, int i) throws SQLException {
                long income = resultSet.getLong("income");
                return income;
            }
        });
        return (Long)income.get(0);
    }

    @Override
    public List<OrgCourseKexiao> summaryKexiaoByOrgId(Collection<Long> orgIds, Collection<String> courseTypeNames, Date startTime, Date endTime) {
        StringBuilder sql = new StringBuilder();
        sql.append("select sum(kexiao) as kexiao,org_id from yunying.org_course_kexiao where ");
        sql.append(" start_time between :startTime and :endTime and org_id in (:orgIds)");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        if (courseTypeNames != null && courseTypeNames.size() > 0) {
            sql.append(" and course_type_name in (:courseTypeNames)");
            param.put("courseTypeNames", courseTypeNames);
        }
        sql.append(" group by org_id");
        final ArrayList<OrgCourseKexiao> ret = new ArrayList<OrgCourseKexiao>();
        this.getNamedJdbcTemplate().query(sql.toString(), param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                OrgCourseKexiao courseKexiao = new OrgCourseKexiao();
                courseKexiao.setOrgId(resultSet.getLong("org_id"));
                courseKexiao.setKexiao(resultSet.getLong("kexiao"));
                ret.add(courseKexiao);
                return null;
            }
        });
        return ret;
    }

    @Override
    public List<OrgCourseKexiao> summaryKexiaoByCourseType(Collection<String> courseTypeNames, Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select sum(kexiao) as kexiao,course_type_name from yunying.org_course_kexiao where ").append(" create_time between :startTime and :endTime and course_type_name in (:courseTypeNames)");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("courseTypeNames", courseTypeNames);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final ArrayList<OrgCourseKexiao> records = new ArrayList<OrgCourseKexiao>();
        this.getNamedJdbcTemplate().query(sb.toString(), param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                OrgCourseKexiao courseKexiao = new OrgCourseKexiao();
                courseKexiao.setKexiao(resultSet.getLong("kexiao"));
                courseKexiao.setCourseTypeName(resultSet.getString("course_type_name"));
                records.add(courseKexiao);
                return null;
            }
        });
        return records;
    }

    @Override
    public void deleteAll() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        this.delete(builder);
    }

    @Override
    public void deleteByTime(Date start, Date end) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ge("create_time", (Serializable)start);
        builder.lt("create_time", (Serializable)end);
        this.delete(builder);
    }
}

