/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.comment.dao.impl;

import com.baijia.tianxiao.dal.comment.dao.OrgCommentAuditDao;
import com.baijia.tianxiao.dal.comment.po.OrgCommentAudit;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.ThreeTuple;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCommentAuditDaoImpl
extends JdbcTemplateDaoSupport<OrgCommentAudit>
implements OrgCommentAuditDao {
    public OrgCommentAuditDaoImpl() {
        super(OrgCommentAudit.class);
    }

    @Override
    public OrgCommentAudit getCommentAuditByOrgId(Long orgId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgCommentAudit)this.uniqueResult(builder);
    }

    @Override
    public int getRank(Long orgId, Boolean recent) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(audit.id)+1 as num from tts.org_comment_audit audit,");
        if (null == recent || recent.booleanValue()) {
            sb.append("(select org_id, area_id, score, comment_count from tts.org_comment_audit where org_id =:orgId) orgInfo ");
            sb.append("where audit.area_id = orgInfo.area_id and (audit.score > orgInfo.score or (audit.score = orgInfo.score and audit.comment_count > orgInfo.comment_count))");
        } else {
            sb.append("(select org_id, area_id, score_all, comment_count from tts.org_comment_audit where org_id =:orgId) orgInfo ");
            sb.append("where audit.area_id = orgInfo.area_id and (audit.score_all > orgInfo.score_all or (audit.score_all = orgInfo.score_all and audit.comment_count > orgInfo.comment_count))");
        }
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        return (Integer)this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getInt("num");
                }
                return null;
            }
        });
    }

    @Override
    public ThreeTuple<Integer, Integer, Integer> getAvgScoreByAreaId(Long areaId) {
        String sql = "select min(score) as min, avg(score) as avg, max(score) as max from tts.org_comment_audit where area_id=:areaId and comment_count > 0";
        HashMap params = Maps.newHashMap();
        params.put("areaId", areaId);
        return (ThreeTuple)this.getNamedJdbcTemplate().query(sql, (Map)params, rs -> rs.next() ? new ThreeTuple((Object)rs.getInt("min"), (Object)rs.getInt("avg"), (Object)rs.getInt("max")) : new ThreeTuple((Object)0, (Object)0, (Object)0));
    }

    @Override
    public ThreeTuple<Integer, Integer, Integer> getAvgRecentScoreByAreaId(Long areaId) {
        String sql = "select min(score_all) as min, avg(score_all) as avg, max(score_all) as max from tts.org_comment_audit where area_id=:areaId and comment_count_all > 0";
        HashMap params = Maps.newHashMap();
        params.put("areaId", areaId);
        return (ThreeTuple)this.getNamedJdbcTemplate().query(sql, (Map)params, rs -> rs.next() ? new ThreeTuple((Object)rs.getInt("min"), (Object)rs.getInt("avg"), (Object)rs.getInt("max")) : new ThreeTuple((Object)0, (Object)0, (Object)0));
    }
}

