/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.constant.OrderEnums;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoMessageDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoMessage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title MessageDaoImpl
 * @desc TODO
 * @author he11o
 * @date 2016年11月25日
 * @version 1.0
 */
@Repository
public class TxVZhiBoMessageDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoMessage> implements TxVZhiBoMessageDao {

    public TxVZhiBoMessageDaoImpl() {
        super(TxVZhiBoMessage.class);
    }

    @Override
    public int deleteByUniqueIdsAndAreaType(long lessonId, Collection<String> uniqueIds, Integer areaType) {
        if (CollectionUtils.isEmpty(uniqueIds)) {
            return 0;
        }
        StringBuilder builder = new StringBuilder();
        Map<String, Object> params = Maps.newHashMap();
        builder.append("update tts.tx_vzhibo_message set isdel=:deleted where lesson_id=:lessonId and isdel=:normal ");
        params.put("deleted", DeleteStatus.DELETED.getValue());
        params.put("lessonId", lessonId);
        params.put("normal", DeleteStatus.NORMAL.getValue());
        if (null != areaType) {
            builder.append("and area_type=:areaType ");
            params.put("areaType", areaType);
        }
        builder.append("and unique_id in (:uniqueIds);");
        params.put("uniqueIds", uniqueIds);
        return this.getNamedJdbcTemplate().update(builder.toString(), params);
    }

    @Override
    public List<TxVZhiBoMessage> getLatestMsgFromDB(long lessonId, int count, int areaType) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.eq("areaType", areaType);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.ne("msgType", MessageTypeEnums.MESSAGERECALL.getCode());
        builder.desc("createTime");
        // builder.setOrder(Order.desc("createTime"));
        builder.setMaxSize(count);
        return queryList(builder);
    }

    @Override
    public TxVZhiBoMessage getByUniqueId(String uniqueId) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("uniqueId", uniqueId);
        // builder.ne("msgType", MessageTypeEnums.MESSAGERECALL.getCode());
        // builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        List<TxVZhiBoMessage> messages = queryList(builder);
        if (CollectionUtils.isNotEmpty(messages)) {
            return messages.get(0);
        }
        return null;
    }

    @Override
    public List<TxVZhiBoMessage> history(Long lessonId, Long id, Integer count, Integer areaType, Integer order) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.eq("areaType", areaType);
        builder.ne("msgType", MessageTypeEnums.MESSAGERECALL.getCode());
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        if (order == null) {
            order = OrderEnums.ASC.getCode();
        }
        if (OrderEnums.DESC.getCode() == order) {
            builder.lt("id", id);
            builder.setOrders(Arrays.asList(Order.desc("id")));
        } else {
            builder.gt("id", id);
            builder.setOrders(Arrays.asList(Order.asc("id")));
        }
        builder.setMaxSize(count);
        return queryList(builder);
    }

}
