/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author caoliang
 * @version 1.0
 * @title TxVZhiBoLessonDaoImpl
 * @desc TODO
 * @date 2016年11月28日
 */
@Repository
public class TxVZhiBoLessonDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoLesson> implements TxVZhiBoLessonDao {

    public TxVZhiBoLessonDaoImpl() {
        super(TxVZhiBoLesson.class);
    }

    @Override
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int id) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("id", id);
        return uniqueResult(builder);
    }

    public static final String SYNC_LESSON_STATUS =
            "update tts.tx_vzhibo_lesson set status=:status where status not in(:statues)  and start_time<:startTime";

    @Override
    public int syncLessonStatus(Date timeBefore, int status) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        params.put("statues", Arrays.<Integer>asList(TxVZhiBoLessonStatusEnums.DELETED.getCode(), status));
        params.put("startTime", timeBefore);
        return this.getNamedJdbcTemplate().update(SYNC_LESSON_STATUS, params);
    }

    @Override
    public List<TxVZhiBoLesson> list(Integer roomId, Integer ownerId, Integer ownerType, Integer status, Integer hidden,
                                     String key, Long lastId, Integer count) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        if (ownerId != null) {
            builder.eq("ownerId", ownerId);
        }
        if (null != ownerType) {
            builder.eq("ownerType", ownerType);
        }
        if (null != status && status != TxVZhiBoLessonStatusEnums.ALL.getCode()) {
            builder.eq("status", status);
        } else {
            builder.ne("status", TxVZhiBoLessonStatusEnums.DELETED.getCode());
        }
        if (null != hidden && -1 != hidden) {
            builder.eq("hidden", hidden);
        }
        if (StringUtils.isNotBlank(key)) {
            builder.like("name", key, MatchMode.ANYWHERE);
        }
        builder.setOrders(Lists.newArrayList(/* Order.asc("status"), */ Order.desc("id")));
        if (null != lastId) {
            builder.lt("id", lastId);
        }
        if (null != count) {
            builder.setMaxSize(count);
        }
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> listOthers(Integer roomId, Integer ownerId, Integer ownerType, Integer status,
                                           Integer hidden, String key, Long lastId, Integer count) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        if (ownerId != null && ownerType != null) {
            builder.or(Expressions.ne("ownerId", ownerId), Expressions.ne("ownerType", ownerType));
        } else if (ownerId != null) {
            builder.ne("ownerId", ownerId);
        } else if (null != ownerType) {
            builder.ne("ownerType", ownerType);
        }
        if (null != status && status != TxVZhiBoLessonStatusEnums.ALL.getCode()) {
            builder.eq("status", status);
        } else {
            builder.ne("status", TxVZhiBoLessonStatusEnums.DELETED.getCode());
        }
        if (null != hidden && -1 != hidden) {
            builder.eq("hidden", hidden);
        }
        if (StringUtils.isNotBlank(key)) {
            builder.like("name", key, MatchMode.ANYWHERE);
        }
        builder.setOrders(Lists.newArrayList(/* Order.asc("status"), */ Order.desc("id")));
        if (null != lastId) {
            builder.lt("id", lastId);
        }
        if (null != count) {
            builder.setMaxSize(count);
        }
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        builder.select("id", "roomId", "status");
        return queryList(builder);
    }

    @Override
    public Map<Long, Integer> getLessonTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(1) count from tts.tx_vzhibo_lesson where org_id in (:orgIds) and status in (0,1) ";

        if (startTime != null) {
            sql += " and start_time>=:startTime and start_time<=:endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql += " group by org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Integer count = rs.getInt("count");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }

        });
    }
}
