
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title WxTemplate
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月30日
 * @version 1.0
 */

@Table(name = "wx_template", catalog = "tts")
@Data
public class WxTemplate {
    
    
    /**
     * @title Type
     * @desc 模版类型
     * @author leiruiqi
     * @date 2016年12月30日
     * @version 1.0
     */
        
    public enum Type{
        
        /**
         * 主页
         */
            
        home(1),
        
        ;
        private Integer code;
        
        
        public Integer getCode() {
        
            return code;
        }

        private Type(Integer code) {

            this.code = code;

        }
    }

    @Id
    @GeneratedValue
    private Long id;
    
    /**
     * 模版编号
     */
    @Column
    private String code;
    
    /**
     * 模版类型
     */
    @Column
    private Integer type;
    
    /**
     * 创建时间
     */
    @Column
    private Date createTime;
    
    /**
     * 更新时间
     */
    @Column
    private Date updateTime;
    
    /**
     * 模版名字
     */
    @Column
    private String name;
    
    /**
     * 模版的缩略图
     */
    @Column
    private String url;
}

    