package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by liuxp on 16/11/17.
 * 学生的课消记录
 */
@Data
@Entity(name = "tx_org_student_kexiao")
@Table(catalog = "yunying")
public class OrgStudentKexiaoRecord {

    @Id
    @GeneratedValue
    @Column
    private long id;
    @Column
    private Long userId;//用户ID
    @Column
    private Long courseId;//课程ID
    @Column
    private Long classId;//班级ID
    @Column
    private Integer courseType;//课程类型，参见CourseType
    @Column
    private Integer chargeUnit;//收费单位，参看ChargeUnit
    @Column
    private Long lessonId;//课节ID
    @Column
    private Long studentLessonId;//学生课节ID
    @Column
    private Long orgId;//机构ID
    @Column
    private Long amount;//课节金额，单位分
    @Column
    private Integer lessonDuration;//课节时长，单位分钟
    @Column
    private Integer kexiaoDuration;//课消时长，正价课时长，单位分钟
    @Column
    private Integer lessonType;//课节类型
    @Column
    private Integer delStatus;//删除状态，0：未删除，1：已删除
    @Column
    private Date markTime;//标记为课消的时间
    @Column
    private Date startTime;//课程开始时间
    @Column
    private Date createTime;
    @Column
    private Date updateTime;
    
//    public Double getLessonDurationHour(){
//    	if(this.lessonDuration!=null){
//    		BigDecimal bValue = new BigDecimal((double)this.lessonDuration/60);
//    		return bValue.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
//    	}
//    	return null;
//    };
}
