/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;

import com.google.common.base.Preconditions;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class OrgCourseSmsDaoImpl extends JdbcTemplateDaoSupport<OrgCourseSms> implements OrgCourseSmsDao {

    /**
     * @param entityClass
     */
    public OrgCourseSmsDaoImpl() {
        super(OrgCourseSms.class);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(Long orgId, Long courseId, Integer userRole, String...queryProps) {
        SingleSqlBuilder<OrgCourseSms> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("courseId", courseId);
        if (userRole != null) {
            builder.eq("userRole", userRole);
        }
        return queryList(builder);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(final Long orgId, Collection<Long> courseIds, final Integer userRole,
        final String...queryProps) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        BatchQueryTemplate<Long, List<OrgCourseSms>> batch = new ListBatchQueryTemplate<>();
        return batch.batchQuery(courseIds, new BatchQueryCallback<Long, List<OrgCourseSms>>() {
            @Override
            public List<OrgCourseSms> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgCourseSms> builder = createSqlBuilder(queryProps);
                builder.eq("orgId", orgId);
                builder.in("courseId", querySet);
                if (userRole != null) {
                    builder.eq("userRole", userRole);
                }
                return queryList(builder);
            }
        });
    }

    @Override
    public OrgCourseSms getOrgCourseSms(Long orgId, Long courseId, Integer userRole, Long userId, String...queryProps) {

        SingleSqlBuilder<OrgCourseSms> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("courseId", courseId);
        builder.eq("userRole", userRole);
        builder.eq("userId", userId);

        return this.uniqueResult(builder);
    }

    @Override
    public void increaseSendTime(Long orgId, Long courseId, Integer userRole, Long userId) {

        OrgCourseSms sms = getOrgCourseSms(orgId, courseId, userRole, userId);
        if (sms != null) {
            sms.setSend(sms.getSend() == null ? 1 : sms.getSend() + 1);
            this.update(sms, "send");
        }
    }

    @Override
    public void setViewStatus(Long id, Integer viewStatus) {

        OrgCourseSms sms = this.getById(id, "id", "viewStatus");
        if (sms != null) {
            sms.setViewStatus(viewStatus);
            this.update(sms, "send");
        }
    }

    @Override
    public void delCourseSmsRecord(Long orgId, Long courseId, Integer userRole, Collection<Long> userIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        Preconditions.checkArgument(userRole != null, "userRole is illegal");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(userIds), "userId is illegal");
        SingleSqlBuilder<OrgCourseSms> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("courseId", courseId);
        builder.eq("userRole", userRole);
        builder.in("userId", userIds);
        delete(builder);
    }

    @Override
    public Map<Long, Integer> courseSmsTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from tts.org_course_sms where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql += " and create_time between :startTime and :endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql += " group by org_id";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

}
