package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseKexiaoDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseKexiao;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Repository
public class OrgCourseKexiaoDaoImpl extends JdbcTemplateDaoSupport<OrgCourseKexiao> implements OrgCourseKexiaoDao {

    @Override
    public long getIncome(Date start, Date end, List<Long> courseIds) {
        if(CollectionUtils.isEmpty(courseIds)){
            return -1;
        }
        StringBuilder sql=new StringBuilder("select sum(kexiao) as income from yunying.org_course_kexiao where create_time >= :start and create_time < :end and course_id in (:courseIds)");
        Map <String,Object>param= Maps.newHashMap();
        param.put("start",start);
        param.put("end",end);
        param.put("courseIds",courseIds);
       List <Long> income= getNamedJdbcTemplate().query(sql.toString(), param, new RowMapper<Long>() {
            @Override
            public Long mapRow(ResultSet resultSet, int i) throws SQLException {

                long income=resultSet.getLong("income");
                return income;


            }
        });
       return income.get(0);
    }

    @Override
    public long getSchoolIncome(Date start, Date end, List<Long> orgIds) {
        if(CollectionUtils.isEmpty(orgIds)){
            return -1;
        }
        StringBuilder sql=new StringBuilder("select sum(kexiao) as income from yunying.org_course_kexiao where create_time >= :start and create_time < :end and org_id in (:orgIds)");
        Map <String,Object>param= Maps.newHashMap();
        param.put("start",start);
        param.put("end",end);
        param.put("orgIds",orgIds);
        List <Long> income= getNamedJdbcTemplate().query(sql.toString(), param, new RowMapper<Long>() {
            @Override
            public Long mapRow(ResultSet resultSet, int i) throws SQLException {

                long income=resultSet.getLong("income");
                return income;


            }
        });
        return income.get(0);
    }
}
