/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.constant.OrderEnums;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoMessageDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoMessage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TxVZhiBoMessageDaoImpl
extends JdbcTemplateDaoSupport<TxVZhiBoMessage>
implements TxVZhiBoMessageDao {
    public TxVZhiBoMessageDaoImpl() {
        super(TxVZhiBoMessage.class);
    }

    @Override
    public int deleteByUniqueIdsAndAreaType(long lessonId, Collection<String> uniqueIds, Integer areaType) {
        if (CollectionUtils.isEmpty(uniqueIds)) {
            return 0;
        }
        StringBuilder builder = new StringBuilder();
        HashMap params = Maps.newHashMap();
        builder.append("update tts.tx_vzhibo_message set isdel=:deleted where lesson_id=:lessonId and isdel=:normal ");
        params.put("deleted", DeleteStatus.DELETED.getValue());
        params.put("lessonId", lessonId);
        params.put("normal", DeleteStatus.NORMAL.getValue());
        if (null != areaType) {
            builder.append("and area_type=:areaType ");
            params.put("areaType", areaType);
        }
        builder.append("and unique_id in (:uniqueIds);");
        params.put("uniqueIds", uniqueIds);
        return this.getNamedJdbcTemplate().update(builder.toString(), (Map)params);
    }

    @Override
    public List<TxVZhiBoMessage> getLatestMsgFromDB(long lessonId, int count, int areaType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)Long.valueOf(lessonId));
        builder.eq("areaType", (Serializable)Integer.valueOf(areaType));
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.ne("msgType", (Serializable)Integer.valueOf(MessageTypeEnums.MESSAGERECALL.getCode()));
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(count));
        return this.queryList(builder);
    }

    @Override
    public TxVZhiBoMessage getByUniqueId(String uniqueId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("uniqueId", (Serializable)((Object)uniqueId));
        List messages = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)messages)) {
            return (TxVZhiBoMessage)messages.get(0);
        }
        return null;
    }

    @Override
    public List<TxVZhiBoMessage> history(Long lessonId, Long id, Integer count, Integer areaType, Integer order) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("areaType", (Serializable)areaType);
        builder.ne("msgType", (Serializable)Integer.valueOf(MessageTypeEnums.MESSAGERECALL.getCode()));
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (order == null) {
            order = OrderEnums.ASC.getCode();
        }
        if (OrderEnums.DESC.getCode() == order.intValue()) {
            builder.lt("id", (Serializable)id);
            builder.setOrders(Arrays.asList(Order.desc((String[])new String[]{"id"})));
        } else {
            builder.gt("id", (Serializable)id);
            builder.setOrders(Arrays.asList(Order.asc((String[])new String[]{"id"})));
        }
        builder.setMaxSize(count);
        return this.queryList(builder);
    }
}

