/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseConsumeRuleDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseConsumeRule>
implements OrgCourseConsumeRuleDao {
    @Override
    public List<OrgCourseConsumeRule> queryConsumRuleListByCourseIds(Long orgId, Collection<Long> courseIds, String ... propes) {
        SingleSqlBuilder builder = this.createSqlBuilder(propes);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.in("courseId", courseIds);
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourseConsumeRule> queryConsumRuleListByUpdateTime(Date date) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ge("updateTime", (Serializable)date);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId, Collection<Long> courseIds) {
        List<OrgCourseConsumeRule> ruleList = this.queryConsumRuleListByCourseIds(orgId, courseIds, new String[0]);
        return CollectorUtil.collectMap(ruleList, (Function)new Function<OrgCourseConsumeRule, Long>(){

            public Long apply(OrgCourseConsumeRule from) {
                return from.getCourseId();
            }
        }, (Function)new Function<OrgCourseConsumeRule, Integer>(){

            public Integer apply(OrgCourseConsumeRule from) {
                return from.getRuleValue();
            }
        });
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"ruleValue"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"ruleValue", "id", "courseId", "orgId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        return (OrgCourseConsumeRule)this.uniqueResult(builder);
    }
}

