/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.comment.dao.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.CommentAudit;
import com.baijia.tianxiao.dal.comment.po.CommentStatic;
import com.baijia.tianxiao.dal.comment.po.OrgCommentAudit;
import com.baijia.tianxiao.dal.comment.po.OrgLessonComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgLessonCommentDaoImpl
extends JdbcTemplateDaoSupport<OrgLessonComment>
implements OrgLessonCommentDao {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonCommentDaoImpl.class);

    public OrgLessonCommentDaoImpl() {
        super(OrgLessonComment.class);
    }

    @Override
    public List<OrgLessonComment> getLessonStudentComments(Long lessonId, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> getLessonTeacherComments(Long lessonId, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.TEACHER.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder);
    }

    @Override
    public OrgLessonComment getLessonCommentDetail(Long lessonId, Long userId, Integer userRole, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("fromId", (Serializable)userId);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return (OrgLessonComment)this.uniqueResult(builder);
    }

    @Override
    public OrgLessonComment getLessonCommentByFromAndTo(Long lessonId, Long fromId, Long toId, Integer userRole, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("fromId", (Serializable)fromId);
        builder.eq("toId", (Serializable)toId);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return (OrgLessonComment)this.uniqueResult(builder);
    }

    @Override
    public List<OrgLessonComment> getStudentComments(Long orgId, Long userId, Boolean isSystem, PageDto pageDto, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("fromId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (null != pageDto) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> getTeacherCommentsOfStudent(Long orgId, Long userId, Boolean isSystem, PageDto pageDto, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("toId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.TEACHER.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (null != pageDto) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public CommentAudit getLessonCommentAudit(Long lessonId, Long orgId, Boolean isSystem) {
        List result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.count("id", "num");
        builder.sum("score", "totalScore");
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.queryList(builder, CommentAudit.class)))) {
            return (CommentAudit)((Object)result.get(0));
        }
        return null;
    }

    @Override
    public CommentAudit starScoreLessonCommentAudit(Long lessonId, Long orgId, Boolean isSystem) {
        List result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.count("id", "num");
        builder.sum("starScore", "totalScore");
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.queryList(builder, CommentAudit.class)))) {
            return (CommentAudit)((Object)result.get(0));
        }
        return null;
    }

    @Override
    public List<CommentAudit> getLessonsCommentAudit(Collection<Long> lessonIds, Long orgId, Integer userRole, Boolean isSystem) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.count("id", "num");
        builder.group("lessonId");
        builder.sum("score", "totalScore");
        builder.in("lessonId", lessonIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)userRole);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder, CommentAudit.class);
    }

    @Override
    public CommentAudit getCommentAudit(Collection<Long> lessonIds, Long orgId, Boolean isSystem) {
        List result;
        if (CollectionUtils.isEmpty(lessonIds)) {
            return new CommentAudit();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.sum("score", "totalScore");
        builder.in("lessonId", lessonIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.queryList(builder, CommentAudit.class)))) {
            return (CommentAudit)((Object)result.get(0));
        }
        return new CommentAudit();
    }

    @Override
    public Map<Long, Integer> getLessonCommentCountMap(Collection<Long> lessonIds, final Long orgId, final Long fromId, final Long toId, final Integer userRole, Boolean isSystem) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonCommentDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.count("id", "num");
                builder.group("lessonId");
                builder.in("lessonId", querySet);
                builder.eq("userRole", (Serializable)userRole);
                builder.eq("orgId", (Serializable)orgId);
                if (fromId != null) {
                    builder.eq("fromId", (Serializable)fromId);
                }
                if (toId != null) {
                    builder.eq("toId", (Serializable)toId);
                }
                final HashMap result = Maps.newHashMap();
                OrgLessonCommentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgLessonComment> getStudentComments(Long orgId, Long userId, Integer userRole, Boolean isFrom, Boolean isSystem, Collection<Long> lessonIds, PageDto pageDto, String ... queryPorps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPorps);
        if (GenericsUtils.isNullOrEmpty(lessonIds)) {
            return GenericsUtils.emptyList();
        }
        builder.eq("orgId", (Serializable)orgId);
        if (isFrom.booleanValue()) {
            builder.eq("fromId", (Serializable)userId);
        } else {
            builder.eq("toId", (Serializable)userId);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.in("lessonId", lessonIds);
        builder.eq("userRole", (Serializable)userRole);
        builder.desc("createTime");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentLessonCommentCount(Long orgId, Long userId, Boolean isSystem) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("fromId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getCommentLessonIdsOfStudent(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("fromId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, List<Long>> getLessonCommentStudentMap(Collection<Long> lessonIds, final Boolean isSystem, final Integer userRole) {
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgLessonComment>>(){

            public List<OrgLessonComment> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonCommentDaoImpl.this.createSqlBuilder(new String[]{"lessonId", "fromId", "toId"});
                builder.in("lessonId", querySet);
                builder.eq("userRole", (Serializable)userRole);
                if (isSystem != null) {
                    builder.eq("isSystem", (Serializable)isSystem);
                }
                return OrgLessonCommentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgLessonComment, Long>(){

            public Long apply(OrgLessonComment arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgLessonComment, Long>(){

            public Long apply(OrgLessonComment arg0) {
                if (userRole.intValue() == UserRole.STUDENT.getRole()) {
                    return arg0.getFromId();
                }
                return arg0.getToId();
            }
        });
    }

    @Override
    public Map<Long, CommentAudit> getTeacherCommentCountMap(Long orgId, Collection<Long> teacherIds, Integer userRole, Date endTime, Boolean isSystem) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((userRole != null ? 1 : 0) != 0, (Object)"userRole is null!");
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Maps.newHashMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(comment.id) as num, sum(comment.score) as score, ");
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            sb.append("comment.to_id as teacherId ");
        } else {
            sb.append("comment.from_id as teacherId ");
        }
        sb.append("from tts.org_lesson_comment comment join tts.org_class_lesson lesson on comment.lesson_id = lesson.id ");
        sb.append("where comment.org_id =:orgId and comment.user_role =:userRole ");
        if (isSystem != null) {
            sb.append("and comment.is_system =:isSystem ");
            params.put("isSystem", isSystem);
        }
        params.put("orgId", orgId);
        params.put("userRole", userRole);
        if (endTime != null) {
            sb.append("and lesson.end_time >:endTime ");
            params.put("endTime", endTime);
        }
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            sb.append("and comment.to_id in (:teacherIds) ");
            sb.append("group by (comment.to_id) ");
        } else {
            sb.append("and comment.from_id in (:teacherIds) ");
            sb.append("group by (comment.from_id) ");
        }
        params.put("teacherIds", teacherIds);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                CommentAudit audit = new CommentAudit();
                audit.setNum(rs.getInt("num"));
                audit.setTotalScore(rs.getInt("score"));
                result.put(rs.getLong("teacherId"), audit);
            }
        });
        return result;
    }

    @Override
    public Map<Integer, Integer> getCommentCountOfOrg(Long orgId, Boolean isSystem, Integer lowScore) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userRole"});
        builder.count("id", "num");
        builder.eq("orgId", (Serializable)orgId);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (lowScore != null) {
            builder.lt("score", (Serializable)lowScore);
        }
        builder.group("userRole");
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getInt("userRole"), rs.getInt("num"));
            }
        });
        return result;
    }

    @Override
    public List<OrgCommentAudit> getOrgCommentAudit(Date startTime, Date endTime, final Boolean isSystem) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgId"});
        builder.count("id", "commentCount");
        builder.sum("score", "totalScore");
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.lt("createTime", (Serializable)endTime);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.group("orgId");
        final ArrayList result = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                OrgCommentAudit audit = new OrgCommentAudit();
                if (isSystem == null) {
                    audit.setCommentCountAll(rs.getInt("commentCount"));
                    audit.setOrgId(rs.getLong("orgId"));
                    audit.setTotalScoreAll(rs.getInt("totalScore"));
                } else {
                    audit.setCommentCount(rs.getInt("commentCount"));
                    audit.setOrgId(rs.getLong("orgId"));
                    audit.setTotalScore(rs.getInt("totalScore"));
                }
                result.add(audit);
            }
        });
        return result;
    }

    @Override
    public List<OrgLessonComment> getComments(Long orgId, Collection<Long> lessonIds, Integer userRole, Integer lowSocre, Boolean hasPic, Integer highScore, PageDto page, Boolean isSystem, String ... queryProps) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)userRole);
        if (lowSocre != null) {
            builder.lt("score", (Serializable)lowSocre);
        }
        if (hasPic != null && hasPic.booleanValue()) {
            builder.ne("storageIds", (Serializable)((Object)""));
        }
        if (highScore != null) {
            builder.gt("score", (Serializable)highScore);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        builder.desc("createTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> getLessonComments(Long lessonId, Boolean isSystem, Integer userRole, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getComment(int userRole, Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("userRole", userRole);
        String sql = "select org_id, count(id) count from tts.org_lesson_comment where user_role = :userRole and org_id in (:orgIds) and is_system = 0";
        if (startTime != null && endTime != null) {
            sql = sql + " AND create_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by org_id ";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Integer getCommentCount(Long orgId, Collection<Long> lessonIds, Integer userRole, Integer lowSocre, Boolean hasPic, Integer highScore, Boolean isSystem) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)userRole);
        if (lowSocre != null) {
            builder.lt("score", (Serializable)lowSocre);
        }
        if (hasPic != null && hasPic.booleanValue()) {
            builder.ne("storageIds", (Serializable)((Object)""));
        }
        if (highScore != null) {
            builder.gt("score", (Serializable)highScore);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getPeriodComment(Long orgId, Collection<Long> lessonIds, Integer userRole, Integer lowSocre, Boolean hasPic, Integer highScore, Boolean isSystem, String startDate, String endDate) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.between("createTime", (Comparable)((Object)startDate), (Comparable)((Object)endDate));
        builder.eq("userRole", (Serializable)userRole);
        if (lowSocre != null) {
            builder.lt("score", (Serializable)lowSocre);
        }
        if (hasPic != null && hasPic.booleanValue()) {
            builder.ne("storageIds", (Serializable)((Object)""));
        }
        if (highScore != null) {
            builder.gt("score", (Serializable)highScore);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Long getSumCommentByTeacher(Long teacherUserId, String ... queryProps) {
        Preconditions.checkArgument((teacherUserId != null ? 1 : 0) != 0, (Object)"teacherUserId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("score");
        builder.eq("toId", (Serializable)teacherUserId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Long getCountCommentByTeacher(Long teacherUserId, String ... queryProps) {
        Preconditions.checkArgument((teacherUserId != null ? 1 : 0) != 0, (Object)"teacherUserId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("toId", (Serializable)teacherUserId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Map<Long, Long> getAveCommentByTeacherIds(Collection<Long> teacherUserIds, String ... queryProps) {
        if (teacherUserIds == null || teacherUserIds.size() == 0) {
            return Maps.newHashMap();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select sum(score)/count(id) as score,to_id as tid from tts.org_lesson_comment where to_id in (:teacherIds) group by to_id");
        HashMap params = Maps.newHashMap();
        params.put("teacherIds", teacherUserIds);
        return (Map)this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Long>>(){

            public Map<Long, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                while (rs.next()) {
                    Long tid = rs.getLong("tid");
                    Long score = rs.getLong("score");
                    map.put(tid, score);
                }
                return map;
            }
        });
    }

    @Override
    public Map<String, Integer> getOrgCommentMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds, Integer userRole) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("userRole", userRole);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        String sql = "SELECT count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' FROM tts.org_lesson_comment where user_role = :userRole and is_system = 0 and org_id in (:orgIds) and create_time>=:startTime and create_time<=:endTime";
        sql = sql + " group by MONTH(create_time),DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String date = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(date, count);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgLessonComment> getComments(@NonNull Long orgId, @NonNull Long lessonId, List<Long> fromIds, List<Long> toIds, @NonNull Integer userRole) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole");
        }
        if (CollectionUtils.isEmpty(fromIds) && CollectionUtils.isEmpty(toIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        if (CollectionUtils.isNotEmpty(fromIds)) {
            builder.in("fromId", fromIds);
        }
        builder.eq("userRole", (Serializable)userRole);
        if (CollectionUtils.isNotEmpty(toIds)) {
            builder.in("toId", toIds);
        }
        return this.queryList(builder);
    }

    @Override
    public OrgLessonComment getByIdAndOrgId(Long commentId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)commentId);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgLessonComment)this.uniqueResult(builder);
    }

    @Override
    public List<OrgLessonComment> listComment(Long orgId, Collection<Long> classIds, Collection<Long> lessonIds, Long searchTeacherUserId, Long cascadeTeacherUserId, Date beginDate, Date endDate, Integer userRole, Integer startScore, Long lastId, Integer pageSize) {
        if (lessonIds != null && CollectionUtils.isEmpty(lessonIds)) {
            return Collections.EMPTY_LIST;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (lessonIds != null && CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        if (userRole != null && userRole != -1) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (startScore != null && startScore != -1) {
            this.buildStarScore((SingleSqlBuilder<OrgLessonComment>)builder, startScore);
        }
        if (searchTeacherUserId != null && searchTeacherUserId > 0L) {
            builder.or(Expressions.eq((String)"fromId", (Serializable)searchTeacherUserId), Expressions.eq((String)"toId", (Serializable)searchTeacherUserId));
        }
        this.buildCoureseTeacher((SingleSqlBuilder<OrgLessonComment>)builder, cascadeTeacherUserId, classIds);
        if (beginDate != null) {
            builder.ge("updateTime", (Serializable)beginDate);
        }
        if (endDate != null) {
            builder.lt("updateTime", (Serializable)endDate);
        }
        if (lastId != null && lastId != -1L) {
            builder.lt("id", (Serializable)lastId);
        }
        builder.eq("isSystem", (Serializable)Integer.valueOf(0));
        builder.desc("id");
        builder.setMaxSize(pageSize);
        log.debug("listComment = {},{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> listSearchComment(Long orgId, Long cascadeTeacherUserId, Collection<Long> classIds, Collection<Long> lessonIds, List<Long> teacherUserid, List<Long> studentUserId, String searchKey, Integer pageSize) {
        if (lessonIds != null && CollectionUtils.isEmpty(lessonIds)) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        final ArrayList<OrgLessonComment> list = new ArrayList<OrgLessonComment>();
        StringBuilder sql = new StringBuilder("select * from tts.org_lesson_comment where org_id = :orgId ");
        if (lessonIds != null) {
            sql.append(" and lesson_id in (:lessonIds) ");
            params.put("lessonIds", lessonIds);
        }
        if (cascadeTeacherUserId != null && cascadeTeacherUserId > 0L) {
            sql.append(" and ((user_role = 0 and from_id = :cascadeTeacherUserId) or (user_role = 2 and to_id = :cascadeTeacherUserId))");
            params.put("cascadeTeacherUserId", cascadeTeacherUserId);
        }
        if (CollectionUtils.isEmpty(classIds)) {
            sql.append(" and ((user_role = 0 and (content like :searchKey or from_id in (:teacherUserid) or to_id in (:studentUserId))) ");
            sql.append(" or (user_role = 2 and (content like :searchKey or from_id in (:studentUserId) or to_id in (:teacherUserid))))");
        } else {
            sql.append(" and ((user_role = 0 and (content like :searchKey or from_id in (:teacherUserid) or to_id in (:studentUserId))) ");
            sql.append(" or (user_role = 2 and (content like :searchKey or from_id in (:studentUserId) or to_id in (:teacherUserid)))");
            sql.append(" or (course_id in (:classIds)))");
            params.put("classIds", classIds);
        }
        sql.append(" and is_system = 0 order by update_time desc limit :pageSize");
        params.put("orgId", orgId);
        params.put("searchKey", "%" + searchKey + "%");
        params.put("teacherUserid", teacherUserid);
        params.put("studentUserId", studentUserId);
        params.put("pageSize", pageSize);
        log.debug("listSearcgComment = {},{}", (Object)sql, params);
        this.getNamedJdbcTemplate().query(sql.toString(), params, (ResultSetExtractor)new ResultSetExtractor<Object>(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                OrgLessonComment orgLessonComment = null;
                while (rs.next()) {
                    orgLessonComment = new OrgLessonComment();
                    orgLessonComment.setId(rs.getLong("id"));
                    orgLessonComment.setOrgId(rs.getLong("org_id"));
                    orgLessonComment.setLessonId(rs.getLong("lesson_id"));
                    orgLessonComment.setCourseId(rs.getLong("course_id"));
                    orgLessonComment.setFromId(rs.getLong("from_id"));
                    orgLessonComment.setToId(rs.getLong("to_id"));
                    orgLessonComment.setUserRole(rs.getInt("user_role"));
                    orgLessonComment.setContent(rs.getString("content"));
                    orgLessonComment.setCustomFastComment(rs.getString("custom_fast_comment"));
                    orgLessonComment.setStorageIds(rs.getString("storage_ids"));
                    orgLessonComment.setSoundId(rs.getInt("sound_id"));
                    orgLessonComment.setSoundLength(rs.getInt("sound_length"));
                    orgLessonComment.setCreateTime(rs.getDate("create_time"));
                    orgLessonComment.setUpdateTime(rs.getDate("update_time"));
                    orgLessonComment.setIsSystem(rs.getBoolean("is_system"));
                    orgLessonComment.setScore(rs.getInt("score"));
                    orgLessonComment.setStarScore(rs.getInt("star_score"));
                    list.add(orgLessonComment);
                }
                return null;
            }
        });
        return list;
    }

    @Override
    public List<OrgLessonComment> listCommentByStudent(Long orgId, Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.or(Expressions.eq((String)"fromId", (Serializable)userId), Expressions.eq((String)"toId", (Serializable)userId));
        builder.desc("updateTime");
        return this.queryList(builder);
    }

    @Override
    public CommentStatic listCommentStatic(Long orgId, Collection<Long> classIds, Collection<Long> lessonIds, Long searchTeacherUserId, Long cascadeTeacherUserId, Date beginDate, Date endDate, Integer userRole, Integer startScore) {
        if (lessonIds != null && CollectionUtils.isEmpty(lessonIds)) {
            return new CommentStatic();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("starScore", "averageScore");
        builder.count("id", "count");
        builder.eq("orgId", (Serializable)orgId);
        if (lessonIds != null && CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        if (userRole != null && userRole != -1) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (startScore != null && startScore != -1) {
            this.buildStarScore((SingleSqlBuilder<OrgLessonComment>)builder, startScore);
        }
        if (searchTeacherUserId != null && searchTeacherUserId > 0L) {
            builder.or(Expressions.eq((String)"fromId", (Serializable)searchTeacherUserId), Expressions.eq((String)"toId", (Serializable)searchTeacherUserId));
        }
        this.buildCoureseTeacher((SingleSqlBuilder<OrgLessonComment>)builder, cascadeTeacherUserId, classIds);
        if (beginDate != null) {
            builder.ge("updateTime", (Serializable)beginDate);
        }
        if (endDate != null) {
            builder.lt("updateTime", (Serializable)endDate);
        }
        builder.eq("isSystem", (Serializable)Integer.valueOf(0));
        log.debug("listCommentStatic = {},{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return (CommentStatic)((Object)this.uniqueResult(builder, CommentStatic.class));
    }

    private void buildCoureseTeacher(SingleSqlBuilder<OrgLessonComment> builder, Long cascadeTeacherUserId, Collection<Long> classIds) {
        if (cascadeTeacherUserId != null && cascadeTeacherUserId.intValue() > -1) {
            if (CollectionUtils.isNotEmpty(classIds)) {
                builder.or(new Expression[]{Expressions.in((String)"courseId", classIds), Expressions.eq((String)"fromId", (Serializable)cascadeTeacherUserId), Expressions.eq((String)"toId", (Serializable)cascadeTeacherUserId)});
            } else {
                builder.or(Expressions.eq((String)"fromId", (Serializable)cascadeTeacherUserId), Expressions.eq((String)"toId", (Serializable)cascadeTeacherUserId));
            }
        } else if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("courseId", classIds);
        }
    }

    private void buildStarScore(SingleSqlBuilder<OrgLessonComment> builder, Integer starScore) {
        if (starScore == 1) {
            builder.ge("starScore", (Serializable)Integer.valueOf(400));
        } else if (starScore == 2) {
            builder.ge("starScore", (Serializable)Integer.valueOf(200));
            builder.lt("starScore", (Serializable)Integer.valueOf(400));
        } else if (starScore == 3) {
            builder.lt("starScore", (Serializable)Integer.valueOf(200));
        }
    }
}

