/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxVZhiBoLessonStudentDaoImpl
extends JdbcTemplateDaoSupport<TxVZhiBoLessonStudent>
implements TxVZhiBoLessonStudentDao {
    private static final String QUERY_STUDENTOPENID_BY_LESSONID = "SELECT COUNT(DISTINCT(open_id)) as c FROM tts.tx_vzhibo_lesson_student WHERE lesson_id =:lessonId";

    public TxVZhiBoLessonStudentDaoImpl() {
        super(TxVZhiBoLessonStudent.class);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        return this.queryList(builder);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        if (null == openId || null == lessonId) {
            return null;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("openId", (Serializable)((Object)openId));
        builder.eq("lessonId", (Serializable)lessonId);
        return (TxVZhiBoLessonStudent)this.uniqueResult(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        if (lastId != null) {
            builder.gt("id", (Serializable)lastId);
        }
        builder.asc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.desc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer queryStudentOpenIdCountByLessonId(Integer lessonId) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("lessonId", lessonId);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(QUERY_STUDENTOPENID_BY_LESSONID, (Map)paramMap, Integer.class);
    }

    @Override
    public Map<String, Integer> mapOpenIdStatus(Long lessonId, Collection<String> openIdList) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(openIdList)) {
            return result;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"openId", "status"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.in("openId", openIdList);
        this.queryList(builder).stream().forEach(student -> result.put(student.getOpenId(), student.getStatus()));
        return result;
    }

    @Override
    public Map<Long, Integer> getLessonStudentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select r.org_id, count(1) count from tts.tx_vzhibo_lesson_student ls,tts.tx_vzhibo_room r,tts.tx_vzhibo_lesson ll where ls.room_id = r.id and ls.lesson_id = ll.id and ll.status in (0,1)  and r.org_id in (:orgIds) ";
        if (startTime != null) {
            sql = sql + " and ll.start_time>=:startTime and ll.start_time<=:endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by r.org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Integer count = rs.getInt("count");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}

