/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxCommonCounterDao;
import com.baijia.tianxiao.dal.org.po.WxCommonCounter;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class WxCommonCounterDaoImpl
extends JdbcTemplateDaoSupport<WxCommonCounter>
implements WxCommonCounterDao {
    @Override
    public int updateByKey(WxCommonCounter wxCommonCounter) {
        return this.updateByKey(wxCommonCounter.getMainKey(), wxCommonCounter.getSecondaryKey(), wxCommonCounter.getValue());
    }

    @Override
    public int updateByKey(String mainKey, String secondaryKey, Long value) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"\u8ba1\u6570\u5668\u7684value\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = "update tts.wx_common_counter set value = :value where main_key = :mainKey and secondary_key = :secondaryKey";
        HashMap condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        condition.put("value", value);
        return this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public int addOne(String mainKey, String secondaryKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = "update tts.wx_common_counter set value = value +1 where main_key = :mainKey and secondary_key = :secondaryKey";
        HashMap condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        return this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public int subOne(String mainKey, String secondaryKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = "update tts.wx_common_counter set value = value -1 where main_key = :mainKey and secondary_key = :secondaryKey and value > 0";
        HashMap condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        return this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public int addOneForMaxValue(String mainKey, String secondaryKey, Long maxValue) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = "update tts.wx_common_counter set value = value +1 where main_key = :mainKey and secondary_key = :secondaryKey and value < :maxValue";
        HashMap condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        condition.put("maxValue", maxValue);
        return this.getNamedJdbcTemplate().update(sql, (Map)condition);
    }

    @Override
    public Long getValueByKey(String mainKey, String secondaryKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("mainKey", mainKey);
        paramMap.put("secondaryKey", secondaryKey);
        String sql = "select value from tts.wx_common_counter where main_key = :mainKey and secondary_key = :secondaryKey";
        return (Long)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Long.class);
    }

    @Override
    public WxCommonCounter getByKey(String mainKey, String secondaryKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("mainKey", (Serializable)((Object)mainKey));
        sqlBuilder.eq("secondaryKey", (Serializable)((Object)secondaryKey));
        return (WxCommonCounter)this.uniqueResult(sqlBuilder);
    }

    @Override
    public List<WxCommonCounter> getListBySecondekeys(String mainKey, Collection<String> secondaryKeys) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mainKey), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(secondaryKeys), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("mainKey", (Serializable)((Object)mainKey));
        sqlBuilder.in("secondaryKey", secondaryKeys);
        return this.queryList(sqlBuilder, WxCommonCounter.class);
    }

    @Override
    public Map<String, Long> getMapBySecondekeys(String mainKey, Collection<String> secondaryKeys) {
        List<WxCommonCounter> list = this.getListBySecondekeys(mainKey, secondaryKeys);
        HashMap map = Maps.newHashMap();
        for (WxCommonCounter counter : list) {
            map.put(counter.getSecondaryKey(), counter.getValue());
        }
        return map;
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public WxCommonCounter selectOneForUpdate(String mainKey, String secondaryKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainKey, secondaryKey}), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String sql = "select * from tts.wx_common_counter where main_key = :mainKey and secondary_key = :secondaryKey for update";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("mainKey", mainKey);
        paramMap.put("secondaryKey", secondaryKey);
        return (WxCommonCounter)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, WxCommonCounter.class);
    }

    @Override
    public List<WxCommonCounter> getListByMainKey(String mainKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mainKey), (Object)"\u8ba1\u6570\u5668\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("mainKey", (Serializable)((Object)mainKey));
        return this.queryList(sqlBuilder, WxCommonCounter.class);
    }
}

