/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.comment.dao.impl;

import com.baijia.tianxiao.dal.comment.dao.OrgCommentAuditDao;
import com.baijia.tianxiao.dal.comment.po.OrgCommentAudit;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCommentAuditDaoImpl
extends JdbcTemplateDaoSupport<OrgCommentAudit>
implements OrgCommentAuditDao {
    public OrgCommentAuditDaoImpl() {
        super(OrgCommentAudit.class);
    }

    @Override
    public OrgCommentAudit getCommentAuditByOrgId(Long orgId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgCommentAudit)this.uniqueResult(builder);
    }

    @Override
    public int getRank(Long orgId, Boolean isSystem) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(audit.id)+1 as num from tts.org_comment_audit audit,");
        if (!isSystem.booleanValue()) {
            sb.append("(select org_id, area_id, score, comment_count from tts.org_comment_audit where org_id =:orgId) orgInfo ");
            sb.append("where audit.area_id = orgInfo.area_id and (audit.score > orgInfo.score or (audit.score = orgInfo.score and audit.comment_count > orgInfo.comment_count))");
        } else {
            sb.append("(select org_id, area_id, score_all, comment_count from tts.org_comment_audit where org_id =:orgId) orgInfo ");
            sb.append("where audit.area_id = orgInfo.area_id and (audit.score_all > orgInfo.score_all or (audit.score_all = orgInfo.score_all and audit.comment_count > orgInfo.comment_count))");
        }
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        return (Integer)this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getInt("num");
                }
                return null;
            }
        });
    }

    @Override
    public List<OrgCommentAudit> getCommentAuditByOrgIds(Collection<Long> orgIds, final String ... queryProps) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCommentAudit>>(){

            public List<OrgCommentAudit> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCommentAuditDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("orgId", querySet);
                return OrgCommentAuditDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public Map<Long, OrgCommentAudit> getCommentAuditMapByOrgIds(Collection<Long> orgIds, final String ... queryProps) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List audits = (List)batch.batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCommentAudit>>(){

            public List<OrgCommentAudit> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCommentAuditDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("orgId", querySet);
                return OrgCommentAuditDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)audits, (Function)new Function<OrgCommentAudit, Long>(){

            public Long apply(OrgCommentAudit arg0) {
                return arg0.getOrgId();
            }
        });
    }

    @Override
    public void updateAllByOrgId(Collection<OrgCommentAudit> audits) {
        if (CollectionUtils.isEmpty(audits)) {
            return;
        }
        ArrayList batchParams = Lists.newArrayList();
        for (OrgCommentAudit audit : audits) {
            HashMap param = Maps.newHashMap();
            param.put("orgId", audit.getOrgId());
            param.put("areaId", audit.getAreaId());
            param.put("score", audit.getScore());
            param.put("commentCount", audit.getCommentCount());
            param.put("totalScore", audit.getTotalScore());
            param.put("scoreAll", audit.getScoreAll());
            param.put("commentCountAll", audit.getCommentCountAll());
            param.put("totalScoreAll", audit.getTotalScoreAll());
            batchParams.add(param);
        }
        String sql = "update tts.org_comment_audit audit set audit.score_all=:scoreAll,audit.comment_count_all=:commentCountAll, audit.total_score_all=:totalScoreAll, audit.score =:score, audit.area_id =:areaId, audit.comment_count=:commentCount, audit.total_score=:totalScore where audit.org_id=:orgId";
        this.getNamedJdbcTemplate().batchUpdate(sql, (Map[])batchParams.toArray(new HashMap[batchParams.size()]));
    }

    @Override
    public void updateAuditTime(Collection<Long> orgIds, Date updateTime) {
        HashMap param = Maps.newHashMap();
        param.put("orgIds", orgIds);
        param.put("updateTime", updateTime);
        String sql = "update tts.org_comment_audit audit set audit.update_time=:updateTime where audit.org_id in (:orgIds)";
        this.getNamedJdbcTemplate().update(sql, (Map)param);
    }
}

