/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.comment.constant;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;

public enum CommentStatus {
    NOT_BEGIN(0, "\u672a\u5f00\u59cb"),
    WAIT_COMMENT(1, "\u5f85\u8bc4\u4ef7"),
    COMMENTED(2, "\u5df2\u8bc4\u4ef7");

    private int code;
    private String message;

    private CommentStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static CommentStatus getCommentStatusByTime(Date startTime, Date endTime, boolean isStudent) {
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"startTime is illegal");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is illegal");
        Calendar now = Calendar.getInstance();
        if (endTime.after(now.getTime())) {
            return NOT_BEGIN;
        }
        return WAIT_COMMENT;
    }
}

