/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title TxVZhiBoLessonStudentDaoImpl
 * @desc TODO
 * @author caoliang
 * @date 2016年11月28日
 * @version 1.0
 */
@Repository
public class TxVZhiBoLessonStudentDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoLessonStudent>
    implements TxVZhiBoLessonStudentDao {

    public TxVZhiBoLessonStudentDaoImpl() {
        super(TxVZhiBoLessonStudent.class);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        return queryList(builder);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        if(null == openId || null == lessonId){
            return null;
        }
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("openId", openId);
        builder.eq("lessonId", lessonId);
        return uniqueResult(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        if (lastId != null) {
            builder.gt("id", lastId);
        }
        builder.asc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize){
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.desc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return queryList(builder);
    }


    private static final String QUERY_STUDENTOPENID_BY_LESSONID =
        "SELECT COUNT(DISTINCT(open_id)) as c FROM tts.tx_vzhibo_lesson_student WHERE lesson_id =:lessonId";

    @Override
    public Integer queryStudentOpenIdCountByLessonId(Integer lessonId) {
        Map<String, Integer> paramMap = Maps.newHashMap();
        paramMap.put("lessonId", lessonId);
        return this.getNamedJdbcTemplate().queryForObject(QUERY_STUDENTOPENID_BY_LESSONID, paramMap, Integer.class);
    }
    
    @Override
    public Map<String, Integer> mapOpenIdStatus(Long lessonId, Collection<String> openIdList) {
        Map<String, Integer> result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(openIdList)) {
            return result;
        }
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder("openId", "status");
        builder.eq("lessonId", lessonId);
        builder.in("openId", openIdList);
        queryList(builder).stream().forEach(student -> result.put(student.getOpenId(), student.getStatus()));
        return result;
    }

}
