
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dto;

import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

import lombok.Data;

/**
 * @title WxLiveRoomDto
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月14日
 * @version 1.0
 */

@Data
public class WxLiveRoomQueryDto {

    /**
     * 机构id
     */
    private Long orgId;
    
    /**
     * 课节id
     */
    private Long lessonId;
    
    /**
     * 课程id
     */
    private Long courseId;
    
    /**
     * 直播间房间号
     */
    private Long roomId;
    
    /**
     * 直播间房间标题
     */
    private String title;
    
    
    private String searchName;
    
    //@DateTimeFormat(pattern="yyyy-MM-dd")
    private Date startDate;
    //@DateTimeFormat(pattern="yyyy-MM-dd")
    private Date endDate;
    
    private Integer playBack;
    /**
     * 直播室状态，由于状态并不会去更新，所以，这个状态会影响下面的4个时间参数。
     */
    private Integer roomStatus;
    
    private Date startTimeStart;
    
    private Date startTimeEnd;
    
    private Date endTimeStart;
    
    private Date endTimeEnd;
    
    public void roomStatus2timeCondition(){
        
        if(roomStatus == null || roomStatus ==0){
            return;
        }
        else{
            Date now = new Date();
            if(roomStatus == 1){
                if(now.after(startTimeStart)){
                    startTimeStart = now;
                }
                
            }else if(roomStatus ==2 ){
                //if(now.before(when))
                startTimeEnd = now;
                endTimeStart = now;
            }else if(roomStatus ==3 ){
                if(now.before(endTimeEnd)){
                    endTimeEnd = now;
                }
                
            }
        }
    }
}

    