
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxFlowRecordDao;
import com.baijia.tianxiao.dal.org.po.WxFlowRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * @title WxFlowRecordDaoImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2017年1月16日
 * @version 1.0
 */

@Repository
public class WxFlowRecordDaoImpl extends JdbcTemplateDaoSupport<WxFlowRecord> implements WxFlowRecordDao {

    @Override
    public Map<Long, Long> groupsumByOrgSourceAndDate(Long orgId, Long sourceId, Integer sourceType, String date,
        final String groupField) {

        Preconditions.checkArgument(date != null, "流量统计求和日期参数不能为空");

        Preconditions.checkArgument(sourceType != null, "流量统计求和类型参数不能为空");

        SingleSqlBuilder<WxFlowRecord> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.sum("flow", "flowsum");

        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (sourceId != null) {
            sqlBuilder.eq("sourceId", sourceId);
        }
        if (date != null) {
            sqlBuilder.eq("date", date);
        }
        if (sourceType != null) {
            sqlBuilder.eq("sourceType", sourceType);
        }
        sqlBuilder.group(groupField);
        final Map<Long, Long> result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sqlBuilder.toSql(), sqlBuilder.collectConditionValue(),
            new RowCallbackHandler() {

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    result.put(rs.getLong(groupField), rs.getLong("flowsum"));
                }
            });

        return result;

    }

    @Override
    public Long sumByOrgSourceAndDate(Long orgId, Long sourceId, Integer sourceType, String date) {

        Preconditions.checkArgument(date != null, "流量统计求和日期参数不能为空");

        Preconditions.checkArgument(sourceType != null, "流量统计求和类型参数不能为空");

        Preconditions.checkArgument((orgId != null || sourceId != null), "流量统计机构好和资源id参数不能全都为空");

        SingleSqlBuilder<WxFlowRecord> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.sum("flow", "flowsum");

        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (sourceId != null) {
            sqlBuilder.eq("sourceId", sourceId);
        }
        if (date != null) {
            sqlBuilder.eq("date", date);
        }
        if (sourceType != null) {
            sqlBuilder.eq("sourceType", sourceType);
        }
        return queryForObject(sqlBuilder, Long.class);

    }

    @Override
    public Long sumByOrgSourceAndDatePrefix(Long orgId, Long sourceId, Integer sourceType, String datePrefix) {

        Preconditions.checkArgument(datePrefix != null, "流量统计求和日期参数不能为空");

        Preconditions.checkArgument(sourceType != null, "流量统计求和类型参数不能为空");

        Preconditions.checkArgument((orgId != null || sourceId != null), "流量统计机构号和资源id参数不能全都为空");

        SingleSqlBuilder<WxFlowRecord> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.sum("flow", "flowsum");

        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (sourceId != null) {
            sqlBuilder.eq("sourceId", sourceId);
        }
        if (datePrefix != null) {
            sqlBuilder.like("date", datePrefix, MatchMode.START);
        }
        if (sourceType != null) {
            sqlBuilder.eq("sourceType", sourceType);
        }
        return queryForObject(sqlBuilder, Long.class);

    }

    @Override
    public Map<Long, Long> groupsumByOrgSourceAndDatePrefix(Long orgId, Long sourceId, Integer sourceType,
        String datePrefix, final String groupField) {

        Preconditions.checkArgument(datePrefix != null, "流量统计求和日期参数不能为空");

        Preconditions.checkArgument(sourceType != null, "流量统计求和类型参数不能为空");

        SingleSqlBuilder<WxFlowRecord> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.sum("flow", "flowsum");

        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (sourceId != null) {
            sqlBuilder.eq("sourceId", sourceId);
        }
        if (datePrefix != null) {
            sqlBuilder.like("date", datePrefix, MatchMode.START);
        }
        if (sourceType != null) {
            sqlBuilder.eq("sourceType", sourceType);
        }
        sqlBuilder.group(groupField);
        final Map<Long, Long> result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sqlBuilder.toSql(), sqlBuilder.collectConditionValue(),
            new RowCallbackHandler() {

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    result.put(rs.getLong(groupField), rs.getLong("flowsum"));
                }
            });

        return result;

    }

}
