/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.comment.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title OrgClassLesson
 * @desc 评价统计表
 * @author cxm
 * @date 2015年10月12日
 * @version 1.0
 */
@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_comment_audit", catalog = "tts")
@Data
public class OrgCommentAudit {

    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column
    private Long areaId;

    // 评价数（不算默认评价）
    @Column
    private Integer commentCount = 0;

    // 总分（不算默认评价）
    @Column
    private Integer totalScore = 0;

    // 得分（不算默认评价）
    @Column
    private Integer score = 0;

    // 评价数（算默认评价）
    @Column
    private Integer commentCountAll = 0;

    // 总分（算默认评价）
    @Column
    private Integer totalScoreAll = 0;

    // 得分（算默认评价）
    @Column
    private Integer scoreAll = 0;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;
}
