package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.dto.KexiaoSumDto;
import com.baijia.tianxiao.dal.org.dto.ChargeUnitStatisticDto;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * Created by liuxp on 16/11/17.
 */
public interface OrgStudentKexiaoRecordDao extends CommonDao<OrgStudentKexiaoRecord> {
    Map<Long, Integer> getFinishCount(Long orgId, Collection<Long> courseIds, Long studentId);

    /**
     * 同一个课程 同一个学生在1个或全部订单的消耗次数和金额
     * <p>
     * signupCourseId=null 取该课程下的全部清单
     *
     * @param orgId
     * @param courseId
     * @param signupCourseId
     * @return
     */
    StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId,List<Integer> status);

    List<OrgStudentKexiaoRecord> getByCourseIdsAndStudentIds(Long orgId, Collection<Long> courseIds, Collection<Long> studentIds, String... props);

    List<OrgStudentKexiaoRecord> getByCourseIdsAndUserIds(Long orgId, Collection<Long> courseIds, Collection<Long> studentIds, String... props);

    public void batchInsertRecords(Collection<OrgStudentKexiaoRecord> records);

    public List<OrgStudentKexiaoRecord> getByStuLessonIds(Long orgId, Collection<Long> lessonIds, String... props);

    /**
     * @param orgId
     * @param studentIds
     * @param courseIds
     * @return
     */
    List<KexiaoStatisticss> findKexiaoStatistics(Long orgId, Collection<Long> studentIds, Collection<Long> courseIds);

    /**
     * @param orgId
     * @param studentIds
     * @param lessonIds
     * @return
     */

    Map<Long,KexiaoStatisticss> findLessonKexiaoStatistics(Long orgId, Collection<Long> studentIds, Collection<Long> lessonIds);
    
    
    /** List */
    List<OrgStudentKexiaoRecord> listByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime);
    List<Long> listIdsByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime);
    List<OrgStudentKexiaoRecord> listByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime);
    
    List<OrgStudentKexiaoRecord> listByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime);
    List<Long> listIdsByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime);
    List<OrgStudentKexiaoRecord> listByClassIds(Collection<Long> classIds, Date startTime, Date endTime);
    List<Long> listIdsByClassIds(Collection<Long> classIds, Date startTime, Date endTime);
    
    List<OrgStudentKexiaoRecord> listByOrgId(Long orgId, Collection<Long> classIds, Collection<Long> userIds, Date startTime, Date endTime);
    List<OrgStudentKexiaoRecord> listByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime);
    
    /** Page */
    List<Long> pageDistinctClassId(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto);
    List<Long> pageDistinctUserId(Long orgId, Collection<Long> userIds, Date startTime, Date endTime, PageDto pageDto);
    
    List<OrgStudentKexiaoRecord> pageByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto);
    Integer countByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime);
    
    /** Map */
    //Map<orgId,Map<chargeType,OrgKexiaoListDto>>
    Map<Long,Map<Integer,ChargeUnitStatisticDto>> mapOrgChargeUnitStatisticDto(Collection<Long> orgIds, Date startTime, Date endTime);
    //Map<classId,Map<chargeType,OrgKexiaoListDto>>
    Map<Long,Map<Integer,ChargeUnitStatisticDto>> mapClassChargeUnitStatisticDto(Collection<Long> classIds, Date startTime, Date endTime);
    //Map<classId,Map<chargeType,OrgKexiaoListDto>>
    Map<Long,Map<Integer,ChargeUnitStatisticDto>> mapUserChargeUnitStatisticDto(Long orgId, Collection<Long> userIds, Date startTime, Date endTime);
    
    //Map<chargeType,OrgKexiaoListDto>
    Map<Integer,ChargeUnitStatisticDto> mapOrgKexiaoListDtoData(Collection<Long> orgIds, Date startTime, Date endTime);
    
    KexiaoSumDto getKexiaoKexiaoSumDto(Collection<Long> orgIds, Collection<Long> classIds, Collection<Long> userIds, List<Integer> chargeUnit, Date startTime, Date endTime);
    
    List<OrgStudentKexiaoRecord> listOrderByStartTime(List<Long> ids);
    
    Long sumAmountByLesson(Collection<Long> lessonIds);
    
    Long sumAmountBy(Collection<Long> orgIds, Date startTime, Date endTime);
    
    //Map<studentUser,amount> 
    Map<Long,Long> sumAmountBy(Collection<Long> lessonIds, Collection<Long> studentUserIds);
    
    //Map<courseId,Map<studentUserId,amount>> 
    Map<Long,Map<Long,Long>> mapCourseStudentAmountBy(Collection<Long> lessonIds);
    

}
