
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.dto.WxLiveRoomQueryDto;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @title OrgWxLiveRoomDaoImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */

@Repository
public class WxLiveRoomDaoImpl extends JdbcTemplateDaoSupport<WxLiveRoom> implements WxLiveRoomDao {

    public List<WxLiveRoom> queryByConditon(WxLiveRoomQueryDto dto, PageDto pageDto) {

        SingleSqlBuilder<WxLiveRoom> sqlBuilder = this.createSqlBuilder();

        if (dto.getOrgId() != null) {
            sqlBuilder.eq("orgId", dto.getOrgId());
        }
        if (dto.getCourseId() != null) {
            sqlBuilder.eq("courseId", dto.getCourseId());
        }

        if (dto.getLessonId() != null) {
            sqlBuilder.eq("lessonId", dto.getLessonId());
        }

        if (dto.getStartTimeStart() != null) {
            sqlBuilder.ge("startTime", dto.getStartTimeStart());
        }

        if (dto.getStartTimeEnd() != null) {
            sqlBuilder.le("startTime", dto.getStartTimeEnd());
        }

        if (dto.getEndTimeStart() != null) {
            sqlBuilder.ge("endTime", dto.getEndTimeStart());
        }

        if (dto.getEndTimeEnd() != null) {
            sqlBuilder.le("endTime", dto.getEndTimeEnd());
        }
        if (StringUtils.isNotBlank(dto.getTitle())) {
            sqlBuilder.like("title", dto.getTitle(), MatchMode.ANYWHERE);
        }
        if (dto.getRoomId() != null) {
            sqlBuilder.eq("roomId", dto.getRoomId());
        }
        if (dto.getPlayBack() != null) {
            sqlBuilder.eq("playBack", dto.getPlayBack());
        }

        sqlBuilder.desc("startTime");
        // sqlBuilder.setOrder(Order.asc("id"));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    public List<WxLiveRoom> queryActiveLiveRoomList() {

        Date now = new Date();

        SingleSqlBuilder<WxLiveRoom> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.le("enterTime", now);

        sqlBuilder.ge("endTime", now);

        return this.queryList(sqlBuilder);
    }

    @Override
    public WxLiveRoom getByRoomId(Long roomId) {

        SingleSqlBuilder<WxLiveRoom> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("roomId", roomId);
        return this.uniqueResult(sqlBuilder);

    }

    @Override
    public List<WxLiveRoom> listByTeacherIdOrAdminId(Long teacherId) {
        SingleSqlBuilder<WxLiveRoom> builder = this.createSqlBuilder();
        builder.or(Expressions.eq("teacherId", teacherId), Expressions.eq("adminId", teacherId));
        builder.eq("delStatus", DeleteStatus.NORMAL.getValue());
        return this.queryList(builder);
    }

}
