package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.SQLOperator;
import com.baijia.tianxiao.sqlbuilder.bean.impl.AndExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.GeExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.GtExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.LeExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.LtExp;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by zhangrui on 16/8/24.
 */
@Repository
@Slf4j
public class OrgLessonConflictDaoImpl extends JdbcTemplateDaoSupport<OrgLessonConflict> implements OrgLessonConflictDao {

    private static final String update = "update tts.org_lesson_conflict set ";

    private static final String count = "select count(id) from tts.org_lesson_conflict where ";

    private static final String insert = "insert into tts.org_lesson_conflict (org_id,lesson_id,teacher_id,room_id,start_time,end_time,del_status) values (:orgId,:lessonId,:teacherId,:roomId,:startTime,:endTime,:delStatus)";

    @Override
    public boolean updateLessonConflictByCondition(Long orgId,Map<String,Object> fileds ,Map<String, Object> condition) {
        StringBuilder sb = new StringBuilder(update);
        Map<String,Object> params = Maps.newHashMap();
        if(fileds.size() > 0){
            for(Map.Entry<String,Object>  entry : fileds.entrySet()) {
                sb.append(entry.getKey() + " = :" +entry.getKey()+ ",");
            }
            //移除最后多余的逗号
            sb.deleteCharAt(sb.length() - 1);
            params.putAll(fileds);
        }else{
            throw new BussinessException(CommonErrorCode.PARAM_ERROR,"需要传入更新的字段");
        }

        if(condition.size() > 0){
            sb.append(" where ");
            int index = 0;
            for(Map.Entry<String,Object>  entry : condition.entrySet()){
                String conditionField = entry.getKey()+"_"+index;
                sb.append(entry.getKey() + " = :"+conditionField+" and ");  //避免fileds和condition里有相同的字段,eg: update table set A=1 where A=2;
                index ++ ;
                params.put(conditionField,entry.getValue());
            }
            //移除最后多余的and
            sb.delete(sb.length() - 4,sb.length());
        }else{
            throw new BussinessException(CommonErrorCode.PARAM_ERROR,"需要传入条件字段");
        }

        log.info("updateLessonConflictByCondition sql:" + sb.toString() + ", params:"+params);
        return getNamedJdbcTemplate().update(sb.toString(),params) > 0;
    }

    @Override
    public List<OrgLessonConflict> queryTeacherLessonConflict(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId, PageDto pageDto) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("org_id",orgId);
        sqlBuilder.eq("teacher_id",teacherId);

        GeExp startGe = new GeExp("start_time",startTime, SQLOperator.GE);
        LtExp startLt = new LtExp("start_time",endTime, SQLOperator.LT);

        GtExp endGt = new GtExp("end_time",startTime, SQLOperator.GT);
        LeExp endLe = new LeExp("end_time",endTime, SQLOperator.LE);

        LtExp startLtStartTime = new LtExp("start_time",startTime, SQLOperator.LT);
        GtExp endGtEndTime = new GtExp("end_time",endTime, SQLOperator.GT);

        AndExp startAndExp = new AndExp(startGe,startLt);
        AndExp endAndExp = new AndExp(endGt,endLe);
        AndExp startEnd = new AndExp(startLtStartTime,endGtEndTime);
        sqlBuilder.or(startAndExp,endAndExp,startEnd);
        sqlBuilder.eq("del_status",DataStatus.NORMAL.getValue());
        if(lessonId != null && lessonId > 0){
            sqlBuilder.ne("lesson_id",lessonId);
        }
        sqlBuilder.asc("start_time");
//        sqlBuilder.setOrder(Order.asc("start_time"));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<OrgLessonConflict> queryRoomLessonConflict(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId, PageDto pageDto) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("org_id",orgId);
        sqlBuilder.eq("room_id",roomId);
        GeExp startGe = new GeExp("start_time",startTime, SQLOperator.GE);
        LtExp startLt = new LtExp("start_time",endTime, SQLOperator.LT);

        GtExp endGt = new GtExp("end_time",startTime, SQLOperator.GT);
        LeExp endLe = new LeExp("end_time",endTime, SQLOperator.LE);

        LtExp startLtStartTime = new LtExp("start_time",startTime, SQLOperator.LT);
        GtExp endGtEndTime = new GtExp("end_time",endTime, SQLOperator.GT);

        AndExp startAndExp = new AndExp(startGe,startLt);
        AndExp endAndExp = new AndExp(endGt,endLe);
        AndExp startEnd = new AndExp(startLtStartTime,endGtEndTime);
        sqlBuilder.or(startAndExp,endAndExp,startEnd);
        sqlBuilder.eq("del_status",DataStatus.NORMAL.getValue());
        if(lessonId != null && lessonId > 0){
            sqlBuilder.ne("lesson_id",lessonId);
        }
        sqlBuilder.asc("start_time");
//        sqlBuilder.setOrder(Order.asc("start_time"));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

	@Override
	public List<OrgLessonConflict> queryConfilctByTeacherIds(Long orgId, List<Long> teacherIds) {
		SingleSqlBuilder<OrgLessonConflict> builder = createSqlBuilder();
		builder.eq("org_id", orgId);
		if(CollectionUtils.isNotEmpty(teacherIds)) {
			builder.in("teacher_id", teacherIds);
		}
		builder.eq("del_status", DataStatus.NORMAL.getValue());
		return queryList(builder);
	}

	@Override
	public List<OrgLessonConflict> queryConfilctByClassRoomIds(Long orgId, List<Long> classRoomIds) {
		SingleSqlBuilder<OrgLessonConflict> builder = createSqlBuilder();
		builder.eq("org_id", orgId);
		if(CollectionUtils.isNotEmpty(classRoomIds)) {
			builder.in("room_id", classRoomIds);
		}
		builder.eq("del_status", DataStatus.NORMAL.getValue());
		return queryList(builder);
	}

    @Override
    public int queryTeacherConflictNum(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId) {
        StringBuilder sb = new StringBuilder(count);
        sb.append(" org_id=:orgId and teacher_id=:teacherId and ((start_time >= :startTime and start_time < :endTime) or (end_time > :startTime and end_time <= :endTime) or (start_time < :startTime and end_time > :endTime)) and del_status="+ DataStatus.NORMAL.getValue());
        Map<String,Object> params = Maps.newHashMap();
        params.put("orgId",orgId);
        params.put("teacherId",teacherId);
        params.put("startTime",startTime);
        params.put("endTime",endTime);
        if(lessonId != null && lessonId > 0){
            sb.append(" and lesson_id != :lessonId ");
            params.put("lessonId",lessonId);
        }
        return getNamedJdbcTemplate().queryForObject(sb.toString(),params,Integer.class);
    }

    @Override
    public int queryRoomConflictNum(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId) {
        StringBuilder sb = new StringBuilder(count);
        sb.append(" org_id=:orgId and room_id=:roomId and ((start_time >= :startTime and start_time < :endTime) or (end_time > :startTime and end_time <= :endTime) or (start_time < :startTime and end_time > :endTime)) and del_status="+ DataStatus.NORMAL.getValue());
        Map<String,Object> params = Maps.newHashMap();
        params.put("orgId",orgId);
        params.put("roomId",roomId);
        params.put("startTime",startTime);
        params.put("endTime",endTime);
        if(lessonId != null && lessonId > 0){
            sb.append(" and lesson_id != :lessonId ");
            params.put("lessonId",lessonId);
        }
        return getNamedJdbcTemplate().queryForObject(sb.toString(),params,Integer.class);
    }

    @Override
    public void updateDelStatus(Set<Object> id) {
        StringBuilder sb = new StringBuilder(update);
        sb.append(" del_status = :delStatus where lesson_id in (:lessonIds)");
        Map<String,Object> params = Maps.newHashMap();
        params.put("delStatus",DataStatus.DELETE.getValue());
        params.put("lessonIds",id);
        getNamedJdbcTemplate().update(sb.toString(),params);
    }

    @Override
    public void saveOrgLessonConflicts(List<OrgLessonConflict> lists) {
        StringBuilder sb = new StringBuilder(insert);
        List<Map<String,Object>> list = null;
        int index = 0;
        int i = 0;
        for(OrgLessonConflict conflict:lists){
            if(i == 0){
                list = Lists.newArrayList();
            }
            Map<String,Object> params = Maps.newHashMap();
            params.put("orgId",conflict.getOrgId());
            params.put("teacherId",conflict.getTeacherId()==null?0:conflict.getTeacherId());
            params.put("roomId",conflict.getRoomId()==null?0:conflict.getRoomId());
            params.put("lessonId",conflict.getLessonId());
            params.put("startTime",conflict.getStartTime());
            params.put("endTime",conflict.getEndTime());
            params.put("delStatus",conflict.getDelStatus()==null?0:conflict.getDelStatus());
            list.add(params);
            i++;index++;
            if(i == 10000 || index == lists.size()){
                Map[] map = new Map[list.size()];
                getNamedJdbcTemplate().batchUpdate(insert,list.toArray(map));
                i = 0;
            }
        }
    }

    @Override
    public Map<Long, List<OrgLessonConflict>> queryConfilctByTeacherIdsAndTimeRange(Long orgId, Collection<Long> teacherIds,
        Date startTime, Date endTime) {
        
            Map<Long, List<OrgLessonConflict>> teacherConflictMap = Maps.newHashMap();
            if(CollectionUtils.isEmpty(teacherIds)){
                return teacherConflictMap;
            }
            SingleSqlBuilder<OrgLessonConflict> builder = createSqlBuilder();
            builder.eq("orgId", orgId);
            builder.in("teacherId", teacherIds);
            builder.between("startTime", startTime, endTime);
            
            builder.eq("delStatus", DataStatus.NORMAL.getValue());
            
            
            
            List<OrgLessonConflict> list = queryList(builder);
            
            for(OrgLessonConflict conflict:list){
                Long teacherId = conflict.getTeacherId();
                List<OrgLessonConflict> tempList = teacherConflictMap.get(teacherId);
                if(tempList == null){
                    tempList = Lists.newArrayList();
                    teacherConflictMap.put(teacherId, tempList);
                }
                
                tempList.add(conflict);
                
            }
            
            return teacherConflictMap;
            
    }

    @Override
    public Map<Long, List<OrgLessonConflict>> queryConfilctByClassRoomIdsAndTimeRange(Long orgId, Collection<Long> classRoomIds,
        Date startTime, Date endTime) {
        
        Map<Long, List<OrgLessonConflict>> roomConflictMap = Maps.newHashMap();
        if(CollectionUtils.isEmpty(classRoomIds)){
            return roomConflictMap;
        }
        SingleSqlBuilder<OrgLessonConflict> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.in("roomId", classRoomIds);
        builder.between("startTime", startTime, endTime);
        builder.eq("delStatus", DataStatus.NORMAL.getValue());
        List<OrgLessonConflict> list = queryList(builder);
        
        for(OrgLessonConflict conflict:list){
            Long roomId = conflict.getRoomId();
            List<OrgLessonConflict> tempList = roomConflictMap.get(roomId);
            if(tempList == null){
                tempList = Lists.newArrayList();
                roomConflictMap.put(roomId, tempList);
            }
            
            tempList.add(conflict);
            
        }
        
        return roomConflictMap;
            
    }
}
