///**
// * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
// */
//
//package com.baijia.tianxiao.dal.org.dao.impl;
//
//import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
//import com.baijia.tianxiao.dal.org.po.OrgCourseSeat;
//import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
//import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
//import com.baijia.tianxiao.util.CollectorUtil;
//import com.baijia.tianxiao.util.query.BatchQueryCallback;
//import com.baijia.tianxiao.util.query.BatchQueryTemplate;
//import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
//import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
//
//import com.google.common.base.Function;
//import com.google.common.collect.Maps;
//
//import org.apache.commons.collections4.CollectionUtils;
//import org.springframework.stereotype.Repository;
//
//import java.util.Collection;
//import java.util.List;
//import java.util.Map;
//
///**
// * @title OrgCourseSeatDaoImpl
// * @desc TODO
// * @author shanyu
// * @date 2015年11月2日
// * @version 1.0
// */
//@Repository
//public class OrgCourseSeatDaoImpl extends JdbcTemplateDaoSupport<OrgCourseSeat> implements OrgCourseSeatDao {
//
//    public OrgCourseSeatDaoImpl() {
//        super(OrgCourseSeat.class);
//    }
//
//    @Override
//    public List<OrgCourseSeat> getSeatsByCourseId(Long courseId, String...propes) {
//        SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder(propes);
//        builder.eq("courseId", courseId);
//        return queryList(builder);
//
//    }
//
//    @Override
//    public Map<Long, Integer> getSeatMap(Long courseId) {
//        List<OrgCourseSeat> list = getSeatsByCourseId(courseId, "userId", "seatId");
//        return CollectorUtil.collectMap(list, new Function<OrgCourseSeat, Long>() {
//            @Override
//            public Long apply(OrgCourseSeat from) {
//                return from.getUserId();
//
//            }
//        }, new Function<OrgCourseSeat, Integer>() {
//            @Override
//            public Integer apply(OrgCourseSeat from) {
//                return from.getSeatId();
//
//            }
//        });
//    }
//
//    @Override
//    public List<Long> getSeatInfoIdsByCourseId(Long courseId) {
//        SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder("id");
//        builder.eq("courseId", courseId);
//        return queryForList(builder, Long.class);
//    }
//
//    @Override
//    public List<Long> getSeatInfoIds(final Long courseId, Collection<Long> userIds) {
//        BatchQueryTemplate<Long, List<Long>> batchQueryTemplate = new ListBatchQueryTemplate<>();
//        return batchQueryTemplate.batchQuery(userIds, new BatchQueryCallback<Long, List<Long>>() {
//            @Override
//            public List<Long> doQuery(Collection<Long> querySet) {
//                SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder("id");
//                builder.eq("courseId", courseId);
//                builder.in("userId", querySet);
//                return queryForList(builder, Long.class);
//            }
//        });
//    }
//
//    @Override
//    public Map<Long, Integer> getSeatInfoIds(Collection<Long> courseIds, final Long userId) {
//        MapBatchQueryTemplate<Long, Long, Integer> batchQueryTemplate = new MapBatchQueryTemplate<>();
//        return batchQueryTemplate.batchQuery(courseIds, new BatchQueryCallback<Long, Map<Long, Integer>>() {
//            @Override
//            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
//                SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder();
//                builder.count("id");
//                builder.select("userId");
//                builder.in("courseId", querySet);
//                builder.eq("userId", userId);
//                builder.group("courseId");
//                List<Map<String, Object>> queryRes = query2ListMap(builder);
//                Map<Long, Integer> result = Maps.newHashMap();
//                for (Map<String, Object> res : queryRes) {
//                    result.put(((Number) (res.get("courseId"))).longValue(), ((Number) (res.get("cnt_id"))).intValue());
//                }
//                return result;
//            }
//        });
//    }
//
//    @Override
//    public Integer getSeatCountByLayoutId(Long layoutId) {
//        SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder();
//        builder.eq("layoutId", layoutId);
//        builder.count("id");
//        return queryForObject(builder, Integer.class);
//    }
//
//    @Override
//    public boolean isSeatUsed(Long courseId, Long layoutId, Integer seatNo) {
//        SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder();
//        builder.eq("courseId", courseId);
//        builder.eq("layoutId", layoutId);
//        builder.eq("seatId", seatNo);
//        List<OrgCourseSeat> list = queryList(builder);
//        if (CollectionUtils.isNotEmpty(list)) {
//            return true;
//        }
//        return false;
//    }
//
//    @Override
//    public OrgCourseSeat getCourseSeat(Long courseId, Long userId) {
//        SingleSqlBuilder<OrgCourseSeat> builder = createSqlBuilder();
//        builder.eq("courseId", courseId);
//        builder.eq("userId", userId);
//        return uniqueResult(builder);
//    }
//
//}
