
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;



/**
 * @title OrgCourseExtraDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月25日
 * @version 1.0
 */
    
@Repository
public class OrgCourseExtraDaoImpl extends JdbcTemplateDaoSupport<OrgCourseExtra> implements OrgCourseExtraDao{

    @Override
    public Map<Long, OrgCourseExtra> queryMapByCourseIds(Collection<Long> courseIds) {
        
        SingleSqlBuilder<OrgCourseExtra> builder = createSqlBuilder();
        builder.in("courseId", courseIds);
        
        List<OrgCourseExtra> list = this.queryList(builder);
        Map<Long,OrgCourseExtra> map = Maps.newHashMap();
        for(OrgCourseExtra course:list){
            map.put(course.getCourseId(), course);
        }
        return map;
            
    }

    @Override
    public int updateByOrgCourseId(OrgCourseExtra orgCourseExtra) {
        
        
        OrgCourseExtra extra = this.getByOrgCourseId(orgCourseExtra.getOrgId(),orgCourseExtra.getCourseId());
        if(extra !=null){
            orgCourseExtra.setId(extra.getId());
            return this.update(orgCourseExtra,false);
        }else{
            return 0;
        }
        
            
    }

    @Override
    public OrgCourseExtra getByOrgCourseId(Long orgId, Long courseId) {
        
        SingleSqlBuilder<OrgCourseExtra> builder = createSqlBuilder();
        builder.eq("courseId", courseId);
        builder.eq("orgId", orgId);
        
        
        OrgCourseExtra extra = this.uniqueResult(builder);
        return extra;
    }

}

    