
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgCommentAudit;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgCommentAuditDao
 * @desc TODO
 * @author shanyu
 * @date 2016年1月22日
 * @version 1.0
 */

public interface OrgCommentAuditDao extends CommonDao<OrgCommentAudit> {

    /**
     * 获取机构评价统计
     * 
     * @param orgId
     * @return
     */
    OrgCommentAudit getCommentAuditByOrgId(Long orgId, String...queryProps);

    /**
     * 获取机构评价统计
     * 
     * @param orgId
     * @return
     */
    List<OrgCommentAudit> getCommentAuditByOrgIds(Collection<Long> orgIds, String...queryProps);

    /**
     * 获取机构评价统计
     * 
     * @param orgId
     * @return
     */
    Map<Long, OrgCommentAudit> getCommentAuditMapByOrgIds(Collection<Long> orgIds, String...queryProps);

    /**
     * 获取机构得分排名
     * 
     * @param orgId
     * @param withSystem 是否要计算默认评价
     * @return
     */
    int getRank(Long orgId, Boolean withSystem);

    /**
     * 更新统计信息
     * 
     * @param audits
     */
    public void updateAllByOrgId(Collection<OrgCommentAudit> audits);

    /**
     * 更新统计时间
     */
    public void updateAuditTime(Collection<Long> orgIds, Date updateTime);

}
