/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TxVZhiBoLessonDaoImpl
extends JdbcTemplateDaoSupport<TxVZhiBoLesson>
implements TxVZhiBoLessonDao {
    public static final String SYNC_LESSON_STATUS = "update tts.tx_vzhibo_lesson set status=:status where status not in(:statues)  and start_time<:startTime";

    public TxVZhiBoLessonDaoImpl() {
        super(TxVZhiBoLesson.class);
    }

    @Override
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)Integer.valueOf(id));
        return (TxVZhiBoLesson)this.uniqueResult(builder);
    }

    @Override
    public int syncLessonStatus(Date timeBefore, int status) {
        HashMap params = Maps.newHashMap();
        params.put("status", status);
        params.put("statues", Arrays.asList(TxVZhiBoLessonStatusEnums.DELETED.getCode(), status));
        params.put("startTime", timeBefore);
        return this.getNamedJdbcTemplate().update(SYNC_LESSON_STATUS, (Map)params);
    }

    @Override
    public List<TxVZhiBoLesson> list(Integer roomId, Integer ownerId, Integer ownerType, Integer status, Integer hidden, String key, Long lastId, Integer count) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        if (ownerId != null) {
            builder.eq("ownerId", (Serializable)ownerId);
        }
        if (null != ownerType) {
            builder.eq("ownerType", (Serializable)ownerType);
        }
        if (null != status && status.intValue() != TxVZhiBoLessonStatusEnums.ALL.getCode()) {
            builder.eq("status", (Serializable)status);
        } else {
            builder.ne("status", (Serializable)Integer.valueOf(TxVZhiBoLessonStatusEnums.DELETED.getCode()));
        }
        if (null != hidden && -1 != hidden) {
            builder.eq("hidden", (Serializable)hidden);
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        builder.setOrders((List)Lists.newArrayList((Object[])new Order[]{Order.desc((String[])new String[]{"id"})}));
        if (null != lastId) {
            builder.lt("id", (Serializable)lastId);
        }
        if (null != count) {
            builder.setMaxSize(count);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> listOthers(Integer roomId, Integer ownerId, Integer ownerType, Integer status, Integer hidden, String key, Long lastId, Integer count) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        if (ownerId != null && ownerType != null) {
            builder.or(Expressions.ne((String)"ownerId", (Serializable)ownerId), Expressions.ne((String)"ownerType", (Serializable)ownerType));
        } else if (ownerId != null) {
            builder.ne("ownerId", (Serializable)ownerId);
        } else if (null != ownerType) {
            builder.ne("ownerType", (Serializable)ownerType);
        }
        if (null != status && status.intValue() != TxVZhiBoLessonStatusEnums.ALL.getCode()) {
            builder.eq("status", (Serializable)status);
        } else {
            builder.ne("status", (Serializable)Integer.valueOf(TxVZhiBoLessonStatusEnums.DELETED.getCode()));
        }
        if (null != hidden && -1 != hidden) {
            builder.eq("hidden", (Serializable)hidden);
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            builder.like("name", (Serializable)((Object)key), MatchMode.ANYWHERE);
        }
        builder.setOrders((List)Lists.newArrayList((Object[])new Order[]{Order.desc((String[])new String[]{"id"})}));
        if (null != lastId) {
            builder.lt("id", (Serializable)lastId);
        }
        if (null != count) {
            builder.setMaxSize(count);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        builder.select(new String[]{"id", "roomId", "status"});
        return this.queryList(builder);
    }
}

