/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.enums.StudentCourseStatus;
import java.math.BigDecimal;

public class StudentLessonStatistics {
    private static final String PREFIX = "stu_lesson_";
    private static final String SEPARATOR = "_";
    private String id;
    private long userId;
    private long orgId;
    private long courseId;
    private long totalCount;
    private long finishedCount;
    private long leftCount;
    private Long totalTime;
    private Long leftTime;
    private Long finishedTime;
    private long totalArrangeTime;
    private long kexiaoTime;
    private BigDecimal leftCountRatio;
    private int studentLessonStatus;

    public boolean isNormalCourse() {
        return this.studentLessonStatus == StudentCourseStatus.NORMAL.getCode();
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX).append(this.userId).append(SEPARATOR).append(this.courseId);
        return sb.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getCourseId() {
        return this.courseId;
    }

    public void setCourseId(long courseId) {
        this.courseId = courseId;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getFinishedCount() {
        return this.finishedCount;
    }

    public void setFinishedCount(long finishedCount) {
        this.finishedCount = finishedCount;
    }

    public long getLeftCount() {
        return this.totalCount - this.finishedCount;
    }

    public void setLeftCount(long leftCount) {
        this.leftCount = leftCount;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getLeftCountRatio() {
        BigDecimal total = new BigDecimal(this.totalCount);
        BigDecimal left = new BigDecimal(this.getLeftCount());
        if (this.getLeftCount() <= 0L) {
            return BigDecimal.ZERO;
        }
        if (this.totalCount <= 0L) {
            return BigDecimal.ZERO;
        }
        return left.divide(total, 2, 6);
    }

    public Long getTotalTime() {
        return this.totalTime;
    }

    public Long getLeftTime() {
        return this.leftTime;
    }

    public Long getFinishedTime() {
        return this.finishedTime;
    }

    public long getTotalArrangeTime() {
        return this.totalArrangeTime;
    }

    public long getKexiaoTime() {
        return this.kexiaoTime;
    }

    public int getStudentLessonStatus() {
        return this.studentLessonStatus;
    }

    public void setTotalTime(Long totalTime) {
        this.totalTime = totalTime;
    }

    public void setLeftTime(Long leftTime) {
        this.leftTime = leftTime;
    }

    public void setFinishedTime(Long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public void setTotalArrangeTime(long totalArrangeTime) {
        this.totalArrangeTime = totalArrangeTime;
    }

    public void setKexiaoTime(long kexiaoTime) {
        this.kexiaoTime = kexiaoTime;
    }

    public void setLeftCountRatio(BigDecimal leftCountRatio) {
        this.leftCountRatio = leftCountRatio;
    }

    public void setStudentLessonStatus(int studentLessonStatus) {
        this.studentLessonStatus = studentLessonStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentLessonStatistics)) {
            return false;
        }
        StudentLessonStatistics other = (StudentLessonStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        if (this.getOrgId() != other.getOrgId()) {
            return false;
        }
        if (this.getCourseId() != other.getCourseId()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getFinishedCount() != other.getFinishedCount()) {
            return false;
        }
        if (this.getLeftCount() != other.getLeftCount()) {
            return false;
        }
        Long this$totalTime = this.getTotalTime();
        Long other$totalTime = other.getTotalTime();
        if (this$totalTime == null ? other$totalTime != null : !((Object)this$totalTime).equals(other$totalTime)) {
            return false;
        }
        Long this$leftTime = this.getLeftTime();
        Long other$leftTime = other.getLeftTime();
        if (this$leftTime == null ? other$leftTime != null : !((Object)this$leftTime).equals(other$leftTime)) {
            return false;
        }
        Long this$finishedTime = this.getFinishedTime();
        Long other$finishedTime = other.getFinishedTime();
        if (this$finishedTime == null ? other$finishedTime != null : !((Object)this$finishedTime).equals(other$finishedTime)) {
            return false;
        }
        if (this.getTotalArrangeTime() != other.getTotalArrangeTime()) {
            return false;
        }
        if (this.getKexiaoTime() != other.getKexiaoTime()) {
            return false;
        }
        BigDecimal this$leftCountRatio = this.getLeftCountRatio();
        BigDecimal other$leftCountRatio = other.getLeftCountRatio();
        if (this$leftCountRatio == null ? other$leftCountRatio != null : !((Object)this$leftCountRatio).equals(other$leftCountRatio)) {
            return false;
        }
        return this.getStudentLessonStatus() == other.getStudentLessonStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StudentLessonStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $userId = this.getUserId();
        result = result * 59 + (int)($userId >>> 32 ^ $userId);
        long $orgId = this.getOrgId();
        result = result * 59 + (int)($orgId >>> 32 ^ $orgId);
        long $courseId = this.getCourseId();
        result = result * 59 + (int)($courseId >>> 32 ^ $courseId);
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        long $finishedCount = this.getFinishedCount();
        result = result * 59 + (int)($finishedCount >>> 32 ^ $finishedCount);
        long $leftCount = this.getLeftCount();
        result = result * 59 + (int)($leftCount >>> 32 ^ $leftCount);
        Long $totalTime = this.getTotalTime();
        result = result * 59 + ($totalTime == null ? 43 : ((Object)$totalTime).hashCode());
        Long $leftTime = this.getLeftTime();
        result = result * 59 + ($leftTime == null ? 43 : ((Object)$leftTime).hashCode());
        Long $finishedTime = this.getFinishedTime();
        result = result * 59 + ($finishedTime == null ? 43 : ((Object)$finishedTime).hashCode());
        long $totalArrangeTime = this.getTotalArrangeTime();
        result = result * 59 + (int)($totalArrangeTime >>> 32 ^ $totalArrangeTime);
        long $kexiaoTime = this.getKexiaoTime();
        result = result * 59 + (int)($kexiaoTime >>> 32 ^ $kexiaoTime);
        BigDecimal $leftCountRatio = this.getLeftCountRatio();
        result = result * 59 + ($leftCountRatio == null ? 43 : ((Object)$leftCountRatio).hashCode());
        result = result * 59 + this.getStudentLessonStatus();
        return result;
    }

    public String toString() {
        return "StudentLessonStatistics(id=" + this.getId() + ", userId=" + this.getUserId() + ", orgId=" + this.getOrgId() + ", courseId=" + this.getCourseId() + ", totalCount=" + this.getTotalCount() + ", finishedCount=" + this.getFinishedCount() + ", leftCount=" + this.getLeftCount() + ", totalTime=" + this.getTotalTime() + ", leftTime=" + this.getLeftTime() + ", finishedTime=" + this.getFinishedTime() + ", totalArrangeTime=" + this.getTotalArrangeTime() + ", kexiaoTime=" + this.getKexiaoTime() + ", leftCountRatio=" + this.getLeftCountRatio() + ", studentLessonStatus=" + this.getStudentLessonStatus() + ")";
    }
}

