/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgClassRoomDaoImpl
extends JdbcTemplateDaoSupport<OrgClassRoom>
implements OrgClassRoomDao {
    public OrgClassRoomDaoImpl() {
        super(OrgClassRoom.class);
    }

    @Override
    public List<OrgClassRoom> getClassRoom(Long orgId, String key, Long branchId, Boolean isDel, Integer recycleStatus, PageDto page, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgid is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (branchId != null) {
            builder.eq("branchId", (Serializable)branchId);
        }
        if (key != null && !key.equals("")) {
            builder.add(Expressions.like((String)"roomName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
        }
        if (isDel != null) {
            builder.eq("delStatus", (Serializable)isDel);
        }
        if (recycleStatus != null) {
            builder.eq("recycleStatus", (Serializable)recycleStatus);
        }
        builder.desc("createTime");
        if (page != null) {
            builder.setPage(page);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, String> getRoomName(final Long orgId, Collection<Long> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(roomIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassRoomDaoImpl.this.createSqlBuilder(new String[]{"roomName", "id"});
                if (orgId != null) {
                    builder.eq("orgId", (Serializable)orgId);
                }
                builder.in("id", querySet);
                final HashMap result = Maps.newHashMap();
                OrgClassRoomDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("id"), rs.getString("roomName"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public int delLogicallyById(long id) {
        return this.updateColumnValueById(Long.valueOf(id), "delStatus", DeleteStatus.DELETED.getValue());
    }

    @Override
    public void refreshClassRoom(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update tts.org_class_room set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<OrgClassRoom> getOrgClassRoomListByRoomIds(Collection<Long> roomIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", roomIds);
        return this.queryList(builder);
    }

    @Override
    public List<OrgClassRoom> getOrgClassRoomByNameAndIds(Long orgId, Collection<Long> roomIds, String query) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(roomIds)) {
            builder.in("id", roomIds);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{query})) {
            builder.like("roomName", (Serializable)((Object)query), MatchMode.ANYWHERE);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgClassRoom> queryListByParam(Long orgId, String key, Collection<Long> orgCourseRoomIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("delStatus", (Serializable)Boolean.valueOf(false));
        builder.eq("recycleStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(orgCourseRoomIds)) {
            builder.notin("id", orgCourseRoomIds);
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"roomName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"roomNumber", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE)));
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgClassRoom> getOrgClassRoomsList(Long orgId, Long branchId, Integer status, Integer order, String key, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (branchId != null) {
            builder.eq("branchId", (Serializable)branchId);
        }
        if (key != null && !key.equals("")) {
            builder.add(Expressions.like((String)"roomName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (status != null) {
            builder.eq("recycleStatus", (Serializable)status);
        }
        this.orderRoomList((SingleSqlBuilder<OrgClassRoom>)builder, order, key);
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    private void orderRoomList(SingleSqlBuilder<OrgClassRoom> builder, Integer order, String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            builder.asc("recycleTime");
            return;
        }
        if (order == null) {
            builder.desc("createTime");
        } else if (order == 2) {
            builder.asc("createTime");
        } else if (order == 5) {
            builder.desc("recycleTime");
        } else if (order == 6) {
            builder.asc("recycleTime");
        } else {
            builder.desc("createTime");
        }
    }

    @Override
    public int moveToRecycleBin(long roomId) {
        StringBuilder sb = new StringBuilder("update tts.org_class_room set recycle_status = 1,recycle_time = now() where id = :id");
        HashMap param = Maps.newHashMap();
        param.put("id", roomId);
        return this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public int removeFromRecycleBin(long roomId) {
        StringBuilder sb = new StringBuilder("update tts.org_class_room set recycle_status = 0,recycle_time = NULL where id = :id");
        HashMap param = Maps.newHashMap();
        param.put("id", roomId);
        return this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<Long> getRecycleRoomId(Long orgId, Collection<Long> roomIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.in("id", roomIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("recycleStatus", (Serializable)Integer.valueOf(DeleteStatus.DELETED.getValue()));
        return this.queryForList(builder, Long.class);
    }
}

