/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.constant.OrderEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoMessageDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoMessage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * @title MessageDaoImpl
 * @desc TODO 
 * @author he11o
 * @date 2016年11月25日
 * @version 1.0
 */
@Repository
public class TxVZhiBoMessageDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoMessage> implements TxVZhiBoMessageDao {

    public TxVZhiBoMessageDaoImpl() {
        super(TxVZhiBoMessage.class);
    }

    @Override
    public List<TxVZhiBoMessage> getLatestMsgFromDB(long lessonId,int count, int areaType) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.eq("areaType", areaType);
        builder.desc("createTime");
//        builder.setOrder(Order.desc("createTime"));
        builder.setMaxSize(count);
        return queryList(builder);
    }
    
    @Override
    public TxVZhiBoMessage getByUniqueId(String uniqueId) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("uniqueId", uniqueId);
        List<TxVZhiBoMessage> messages = queryList(builder);
        if(CollectionUtils.isNotEmpty(messages)){
            return messages.get(0);
        }
        return null;
    }

    @Override
    public List<TxVZhiBoMessage> history(Long lessonId, Long id, Integer count, Integer areaType, Integer order) {
        SingleSqlBuilder<TxVZhiBoMessage> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.eq("areaType", areaType);
        if(order == null){
            order = OrderEnums.ASC.getCode();
        }
        if(OrderEnums.DESC.getCode() == order){
            builder.lt("id", id);
            builder.setOrders(Arrays.asList(Order.desc("id")));
        }else{
            builder.gt("id", id);
            builder.setOrders(Arrays.asList(Order.desc("id")));
        }
        builder.setMaxSize(count);
        return queryList(builder);
    }

    
    
}
