/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;

/**
 * @title TxVZhiBoLessonDaoImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年11月28日
 * @version 1.0
 */
@Repository
public class TxVZhiBoLessonDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoLesson> implements TxVZhiBoLessonDao {

    public TxVZhiBoLessonDaoImpl() {
        super(TxVZhiBoLesson.class);
    }

    @Override
    public int countOthersLesson(Integer roomId,Integer ownerId, Order order, PageDto dto) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("roomId", roomId);
        builder.ne("ownerId", ownerId);
        // 注意,此处小明升级了sql-builder为1.1,支持多个order排序,使用addOrder
        builder.addOrder(order);
//        builder.setOrder(order);
        return this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxVZhiBoLesson> queryOthersByCondition(Integer roomId,Integer ownerId, Order order, PageDto dto) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        builder.ne("ownerId", ownerId);
        builder.addOrder(order);
//        builder.setOrder(order);
        return queryList(builder);
    }

    @Override
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int id) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("id", id);
        return uniqueResult(builder);
    }

    public static final String SYNC_LESSON_STATUS = "update tts.tx_vzhibo_lesson set status=:status where status <>:status  and start_time<:startTime";
    @Override
    public int syncLessonStatus(Date timeBefore,int status) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        params.put("startTime", timeBefore);
        return this.getNamedJdbcTemplate().update(SYNC_LESSON_STATUS, params);
    }

    @Override
    public List<TxVZhiBoLesson> list(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order order,int status) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        if(ownerId != null){
            builder.eq("ownerId", ownerId);
        }
        if(status != -1){
            builder.eq("status", status);
        }else{
            builder.ne("status", TxVZhiBoLessonStatusEnums.DELETED.getCode());
        }
        if(lastId != null){
            TxVZhiBoLesson boLesson = getById(lastId);
            if(boLesson != null){
                //TODO order 没法判断是asc 还是 desc
                builder.lt("startTime", boLesson.getStartTime());
            }
        }
        if(pageSize != null){
            builder.setMaxSize(pageSize);
        }
        builder.addOrder(order);
//        builder.setOrder(order);
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> listOthers(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order order,
        int status) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        if(ownerId != null){
            builder.ne("ownerId", ownerId);
        }
        if(status != -1){
            builder.eq("status", status);
        }else{
            builder.ne("status", TxVZhiBoLessonStatusEnums.DELETED.getCode());
        }
        if(lastId != null){
            TxVZhiBoLesson boLesson = getById(lastId);
            if(boLesson != null){
                //TODO order 没法判断是asc 还是 desc
                builder.lt("startTime", boLesson.getStartTime());
            }
        }
        if(pageSize != null){
            builder.setMaxSize(pageSize);
        }
        builder.addOrder(order);
//        builder.setOrder(order);
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId) {
        SingleSqlBuilder<TxVZhiBoLesson> builder = createSqlBuilder();
        builder.eq("roomId", roomId);
        builder.select("id","roomId","status");
        return queryList(builder);
    }
    
}
