/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * @title OrgStudentLesson
 * @desc 机构课节学生关联表
 * @author shanyu
 * @date 2015年10月12日
 * @version 1.0
 */

@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_student_lesson", catalog = "tts")
@Data
public class OrgStudentLesson implements OrgResource {

    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column
    private Long lessonId;

    @Column(name = "student_id")
    private Long userId;

    @Column
    private Long courseId;

    @Column
    private String studentName;

    @Column
    private String studentMobile;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;

    @Column
    private Integer delStatus;

    @Column
    private Integer startStatus;

    @Column
    private Integer kexiaoStatus;//课消状态

    @Column
    private Integer lessonType;//-1,未知，1：正价课，2：赠送课

    @Column
    private Integer lessonDuration;//课节时长

    @Column
    private Integer kexiaoDuration;//课消时长，正价课时长

    private OrgClassLesson lesson;

    @Override
    public Long getResourceId() {
        return this.userId;
    }

    @Override
    public String getResourceName() {
        return this.studentName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        OrgStudentLesson lesson = (OrgStudentLesson) o;

        return new EqualsBuilder()
                .append(id, lesson.id)
                .append(orgId, lesson.orgId)
                .append(lessonId, lesson.lessonId)
                .append(userId, lesson.userId)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(id)
                .append(orgId)
                .append(lessonId)
                .append(userId)
                .toHashCode();
    }
}
