/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * @title OrgClassLesson
 * @desc 课节表
 * @author cxm
 * @date 2015年10月12日
 * @version 1.0
 */
@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_class_lesson", catalog = "tts")
@Data
public class OrgClassLesson implements OrgResource {

    @Id
    @GeneratedValue
    @Column
    private Long id;

    @Column
    private Long orgId;

    @Column
    private Long courseId;

    @Column
    private Long layoutId;

    @Column
    private Long roomId;

    @Column
    private Date startTime;

    @Column
    private Date endTime;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;

    @Column
    private Integer delStatus;

    @Column(name = "number")
    private Integer number;

    @Column
    private String name;

    @Override
    public Long getResourceId() {
        return this.roomId;
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    public OrgClassLesson getLesson() {
        return this;
    }
    
    
    public Long getDurationMinute(){
    	return (this.endTime.getTime() - this.startTime.getTime())/1000/60;
    }

}
