
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomRecordDao;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.date.DateUtil;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @title OrgWxLiveRoomRecordDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */

@Repository
public class WxLiveRoomRecordDaoImpl extends JdbcTemplateDaoSupport<WxLiveRoomRecord> implements WxLiveRoomRecordDao {

    public List<WxLiveRoomRecord> querySumGroupByOrg(Date startTime,Date endTime){
        
        SingleSqlBuilder<WxLiveRoomRecord> sqlBuilder = this.createSqlBuilder("orgId","queryTime");
        
        sqlBuilder.sum("num", "num");
        
        sqlBuilder.ge("queryTime", startTime);
        sqlBuilder.le("queryTime",endTime );
        sqlBuilder.isNotNull("roomId");
        sqlBuilder.groupByNames("orgId","queryTime");
        return this.queryList(sqlBuilder);
    }
    
    public List<WxLiveRoomRecord> querySumByOrg(Long orgId,Date startTime,Date endTime){
        
        SingleSqlBuilder<WxLiveRoomRecord> sqlBuilder = this.createSqlBuilder("orgId","queryTime");
        
        
        sqlBuilder.sum("num", "num");
        
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.ge("queryTime", startTime);
        sqlBuilder.le("queryTime",endTime );
        sqlBuilder.isNotNull("roomId");
        
        sqlBuilder.groupByNames("queryTime");
        
        return this.queryList(sqlBuilder);
    }
    
   
    @Override
    public List<WxLiveRoomRecord> queryDailyOrgNum(Long orgId, Date startTime, Date endTime) {
        
        SingleSqlBuilder<WxLiveRoomRecord> sqlBuilder = this.createSqlBuilder();
        
        //sqlBuilder.max("num", "num");
        
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.ge("queryTime", startTime);
        sqlBuilder.le("queryTime",endTime );
        sqlBuilder.eq("roomId", 0);
        sqlBuilder.addOrder(Order.asc("createTime","queryTime"));
        
        return this.queryList(sqlBuilder);
            
    }

    @Override
    public WxLiveRoomRecord getOrgTodayMaxNumRecord(Long orgId) {
        
        Date now = new Date();
        Date startTime = DateUtil.getStartOfDay(now);
        
        SingleSqlBuilder<WxLiveRoomRecord> sqlBuilder = this.createSqlBuilder("orgId","queryTime");
        
        sqlBuilder.max("num", "num");
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("roomId", 0);
        sqlBuilder.ge("queryTime", startTime);
        
        return this.uniqueResult(sqlBuilder);
            
    }
    
    @Override
    public WxLiveRoomRecord getOrgMonthMaxNumRecord(Long orgId) {
        
        Date now = new Date();
        
        Date startTime = DateUtil.getFirstDate(now);
        
        SingleSqlBuilder<WxLiveRoomRecord> sqlBuilder = this.createSqlBuilder("orgId","queryTime");
        
        sqlBuilder.max("num", "num");
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("roomId", 0);
        sqlBuilder.ge("queryTime", startTime);
        
        return this.uniqueResult(sqlBuilder);
            
    }
    
}

    