
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxCommonCounterDao;
import com.baijia.tianxiao.dal.org.po.WxCommonCounter;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title WxCommonCounterDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年2月3日
 * @version 1.0
 */

@Repository
public class WxCommonCounterDaoImpl extends JdbcTemplateDaoSupport<WxCommonCounter> implements WxCommonCounterDao{

    @Override
    public int updateByKey(WxCommonCounter wxCommonCounter) {
        
        return updateByKey(wxCommonCounter.getMainKey(),wxCommonCounter.getSecondaryKey(),wxCommonCounter.getValue());
            
    }

    @Override
    public int updateByKey(String mainKey, String secondaryKey, Long value) {

        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        Preconditions.checkArgument(value!=null, "计数器的value不能为空");
        
        String sql = "update tts.wx_common_counter set value = :value where main_key = :mainKey and secondary_key = :secondaryKey";
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        condition.put("value", value);
        
        return this.getNamedJdbcTemplate().update(sql, condition);
            
    }

    @Override
    public int addOne(String mainKey, String secondaryKey) {
        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        String sql = "update tts.wx_common_counter set value = value +1 where main_key = :mainKey and secondary_key = :secondaryKey";
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        
        return this.getNamedJdbcTemplate().update(sql, condition);
            
    }

    @Override
    public int subOne(String mainKey, String secondaryKey) {
        
        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        String sql = "update tts.wx_common_counter set value = value -1 where main_key = :mainKey and secondary_key = :secondaryKey and value > 0";
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        
        return this.getNamedJdbcTemplate().update(sql, condition);
            
    }

    @Override
    public int addOneForMaxValue(String mainKey, String secondaryKey, Long maxValue) {

        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        String sql = "update tts.wx_common_counter set value = value +1 where main_key = :mainKey and secondary_key = :secondaryKey and value < :maxValue";
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("mainKey", mainKey);
        condition.put("secondaryKey", secondaryKey);
        condition.put("maxValue", maxValue);
        
        return this.getNamedJdbcTemplate().update(sql, condition);
            
    }

    @Override
    public Long getValueByKey(String mainKey, String secondaryKey) {
        
        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        Map<String,Object> paramMap = Maps.newHashMap();
        paramMap.put("mainKey", mainKey);
        paramMap.put("secondaryKey", secondaryKey);
        
        String sql = "select value from tts.wx_common_counter where main_key = :mainKey and secondary_key = :secondaryKey";
        
        return this.getNamedJdbcTemplate().queryForObject(sql, paramMap, Long.class);
            
    }

    @Override
    public WxCommonCounter getByKey(String mainKey, String secondaryKey) {
        
        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        SingleSqlBuilder<WxCommonCounter> sqlBuilder = this.createSqlBuilder();
        
        sqlBuilder.eq("mainKey", mainKey);
        sqlBuilder.eq("secondaryKey", secondaryKey);
        
        return this.uniqueResult(sqlBuilder);
            
    }

    @Override
    public List<WxCommonCounter> getListBySecondekeys(String mainKey, Collection<String> secondaryKeys) {
        
        Preconditions.checkArgument(StringUtils.isNotBlank(mainKey), "计数器的key不能为空");
        
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(secondaryKeys), "计数器的key不能为空");
        
        SingleSqlBuilder<WxCommonCounter> sqlBuilder = this.createSqlBuilder();
        
        sqlBuilder.eq("mainKey", mainKey);
        sqlBuilder.in("secondaryKey", secondaryKeys);
        
        return this.queryList(sqlBuilder, WxCommonCounter.class);
        
    }

    @Override
    public Map<String, Long> getMapBySecondekeys(String mainKey, Collection<String> secondaryKeys) {
        
        List<WxCommonCounter> list = this.getListBySecondekeys(mainKey, secondaryKeys);
        
        Map<String,Long> map = Maps.newHashMap();
        for(WxCommonCounter counter:list){
            map.put(counter.getSecondaryKey(), counter.getValue());
        }
        
        return map;
            
    }

    @Transactional(propagation=Propagation.MANDATORY)
    @Override
    public WxCommonCounter selectOneForUpdate(String mainKey, String secondaryKey) {
        
        Preconditions.checkArgument(StringUtils.isNoneBlank(mainKey,secondaryKey), "计数器的key不能为空");
        
        String sql = "select * from tts.wx_common_counter where main_key = :mainKey and secondary_key = :secondaryKey for update";
        
        Map<String,Object> paramMap = Maps.newHashMap();
        paramMap.put("mainKey", mainKey);
        paramMap.put("secondaryKey", secondaryKey);
        
        return this.getNamedJdbcTemplate().queryForObject(sql, paramMap, WxCommonCounter.class);
            
    }

    @Override
    public List<WxCommonCounter> getListByMainKey(String mainKey) {
        
        Preconditions.checkArgument(StringUtils.isNotBlank(mainKey), "计数器的key不能为空");
        
        SingleSqlBuilder<WxCommonCounter> sqlBuilder = this.createSqlBuilder();
        sqlBuilder.eq("mainKey", mainKey);
        
        return this.queryList(sqlBuilder, WxCommonCounter.class);
            
    }

    
}

    