package com.baijia.tianxiao.dal.org.dao.impl;


import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.dto.KexiaoSumDto;
import com.baijia.tianxiao.dal.org.dto.ChargeUnitStatisticDto;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by liuxp on 16/11/17.
 */
@Repository
@Slf4j
public class OrgStudentKexiaoRecordDaoImpl extends JdbcTemplateDaoSupport<OrgStudentKexiaoRecord>
        implements OrgStudentKexiaoRecordDao {


    @Override
    public Map<Long, Integer> getFinishCount(Long orgId, Collection<Long> courseIds, Long studentId) {
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        Map<String, Object> params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("select course_id,count(id) as finished ");
        sb.append("from yunying.tx_org_student_kexiao ");
        sb.append("where org_id=:orgId AND student_id=:userId and course_id in(:courseId) and del_status = 0 ");
        sb.append("group by course_id ");
        params.put("orgId", orgId);
        params.put("userId", studentId);
        params.put("courseId", courseIds);
        final Map<Long, Integer> result = Maps.newHashMap();
        getNamedJdbcTemplate().query(sb.toString(), params, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("course_id"), rs.getInt("finished"));
            }
        });
        return result;
    }

    @Override
    public StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        Preconditions.checkArgument(courseId != null, "courseId is null!");

        Map<String, Object> params = Maps.newHashMap();
        params.put("courseId", courseId);
        params.put("userId", userId);
        params.put("status", status);

        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) finishCount,ifNull(sum(ss.lesson_duration),0) finishTime,ifNull(sum(ss.amount),0) finishMoney ");
        if (signupCourseId != null) {
            sb.append(
                    " from (select scl.signup_course_id,scl.lesson_duration,skx.amount from yunying.tx_signup_course_lesson scl right join");
            sb.append(" yunying.tx_org_student_kexiao skx on scl.lesson_id=skx.lesson_id and  scl.user_id=skx.user_id where scl.course_id = :courseId and scl.user_id =:userId and scl.signup_course_id= :signupCourseId");
            params.put("signupCourseId", signupCourseId);
        } else {
            sb.append(
                    " from (select scl.signup_course_id,scl.lesson_duration,skx.amount from yunying.tx_signup_course_lesson scl right join");
            sb.append(" yunying.tx_org_student_kexiao skx on scl.lesson_id=skx.lesson_id and  scl.user_id=skx.user_id where scl.course_id = :courseId and scl.user_id =:userId ");
        }
        sb.append(" and scl.signup_course_id!=-1) ss left join yunying.org_signup_course sc on ss.signup_course_id= sc.id where sc.status in (:status)");

        final StudentCourseKexiaoDocument result = new StudentCourseKexiaoDocument();
        getNamedJdbcTemplate().query(sb.toString(), params, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                result.setFinishCount(rs.getLong("finishCount"));
                result.setFinishMoney(rs.getLong("finishMoney"));
                result.setFinishTime(rs.getLong("finishTime"));
            }
        });

        log.debug("StudentCourseKexiaoDocument finishCountMoney={},sql={},params={}", result, sb.toString(), params);
        return result;
    }


    @Override
    public List<OrgStudentKexiaoRecord> getByCourseIdsAndStudentIds(Long orgId, Collection<Long> courseIds,
                                                                    Collection<Long> studentIds, String... props) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder(props);
        builder.eq("orgId", orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            builder.in("studentId", studentIds);
        }
        return queryList(builder);
    }

    @Override
    public List<OrgStudentKexiaoRecord> getByCourseIdsAndUserIds(Long orgId, Collection<Long> classIds,
                                                                 Collection<Long> userIds, String... props) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder(props);
        builder.eq("orgId", orgId);
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        return queryList(builder);
    }

    @Override
    public void batchInsertRecords(Collection<OrgStudentKexiaoRecord> records) {
        String fields =
                "user_id,course_id,class_id,lesson_id,student_lesson_id,org_id,amount,lesson_duration,charge_unit,lesson_type,del_status,mark_time,start_time,create_time,update_time,kexiao_duration";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("insert into yunying.tx_org_student_kexiao(").append(fields).append(
                ") values(:userId,:courseId,:classId,:lessonId,:studentLessonId,:orgId,:amount,:lessonDuration,:chargeUnit,:lessonType,:delStatus,:markTime,:startTime,:createTime,:updateTime,:kexiaoDuration)");
        SqlParameterSource[] batch = SqlParameterSourceUtils.createBatch(records.toArray());
        getNamedJdbcTemplate().batchUpdate(sqlBuilder.toString(), batch);
    }

    @Override
    public List<OrgStudentKexiaoRecord> getByStuLessonIds(Long orgId, Collection<Long> lessonIds, String... props) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder(props);
        builder.eq("orgId", orgId);
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("studentLessonId", lessonIds);
        }
        return queryList(builder);
    }

    @Override
    public List<KexiaoStatisticss> findKexiaoStatistics(Long orgId, Collection<Long> userIds,
                                                        Collection<Long> courseIds) {
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        Map<String, Object> paramMap = Maps.newHashMap();
        String courseCondition = "";
        if (GenericsUtils.notNullAndEmpty(courseIds)) {
            courseCondition = " and course_id in(:courseIds) ";
            paramMap.put("courseIds", courseIds);
        }
        String sql =
                "select user_id as userId ,course_id as courseId,sum(if(lesson_type=1,amount,0)) as kexiaoMoney,sum(lesson_duration) as kexiaoTime "
                        + "from yunying.tx_org_student_kexiao "
                        + "where org_id = :orgId and user_id in(:userIds) and del_status =:delStatus " + courseCondition
                        + " group by user_id,course_id";
        paramMap.put("userIds", userIds);
        paramMap.put("delStatus", DeleteStatus.NORMAL.getValue());
        paramMap.put("orgId", orgId);
        log.info("sql is :{} and paramMap is :{} ", sql, paramMap);
        final List<KexiaoStatisticss> retList = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<KexiaoStatisticss>() {
            @Override
            public KexiaoStatisticss extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    KexiaoStatisticss kss;
                    try {
                        kss = new KexiaoStatisticss();
                        long userId = rs.getLong("userId");
                        Long courseId = rs.getLong("courseId");
                        Long kexiaoMoney = rs.getLong("kexiaoMoney");
                        Long kexiaoTime = rs.getLong("kexiaoTime");
                        kss.setUserId(userId);
                        kss.setCourseId(courseId);
                        kss.setKexiaoTime(kexiaoTime);
                        kss.setKexiaoMoney(kexiaoMoney);
                        retList.add(kss);
                    } catch (Exception e) {
                        log.error("exception is :{} ", e);
                    }
                }
                return null;
            }
        });
        log.info("retList is:{} ", retList);
        return retList;
    }

    @Override
    public Map<Long, KexiaoStatisticss> findLessonKexiaoStatistics(Long orgId, Collection<Long> userIds,
                                                                   Collection<Long> lessonIds) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder =
                createSqlBuilder("userId", "lessonId", "amount", "lessonDuration", "lessonType");
        builder.eq("orgId", orgId);
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        builder.eq("delStatus", DeleteStatus.NORMAL.getValue());
        List<OrgStudentKexiaoRecord> queryList = this.queryList(builder);
        queryList =
                GenericsUtils.isNullOrEmpty(queryList) ? GenericsUtils.<OrgStudentKexiaoRecord>emptyList() : queryList;

        Map<Long, KexiaoStatisticss> ret = Maps.newHashMap();
        for (OrgStudentKexiaoRecord record : queryList) {
            KexiaoStatisticss kexiaoStatistics = new KexiaoStatisticss();
            kexiaoStatistics.setLessonId(record.getLessonId());
            kexiaoStatistics.setKexiaoMoney(record.getAmount());
            kexiaoStatistics.setKexiaoTime(record.getLessonDuration().longValue());
            kexiaoStatistics.setLessonType(record.getLessonType());
            ret.put(record.getLessonId(), kexiaoStatistics);
        }
        return ret;
    }

    @Override
    public List<OrgStudentKexiaoRecord> listByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (classIds != null) {
            builder.in("classId", classIds);
        }
        if (userId != null) {
            builder.eq("userId", userId);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }
        builder.asc("startTime");

        return queryList(builder);
    }

    @Override
    public List<Long> listIdsByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.tx_org_student_kexiao WHERE 1=1");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (userId != null) {
            builder.append(" AND user_id=:userId");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }
        builder.append(" ORDER BY start_time DESC");


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("userId", userId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<OrgStudentKexiaoRecord> listByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (classId != null) {
            builder.eq("classId", classId);
        }
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }

        builder.asc("startTime");

        return queryList(builder);
    }

    @Override
    public List<Long> listIdsByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.tx_org_student_kexiao WHERE 1=1");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (classId != null) {
            builder.append(" AND class_id=:classId");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }

        builder.append(" ORDER BY start_time DESC");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classId", classId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("id"));
                return 1;
            }
        });

        return result;
    }


    @Override
    public List<OrgStudentKexiaoRecord> listByOrgId(Long orgId, Collection<Long> classIds, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (classIds != null) {
            builder.in("classId", classIds);
        }
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("start_time", startTime);
        }
        if (endTime != null) {
            builder.le("start_time", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<Long> pageDistinctClassId(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(class_id) FROM yunying.tx_org_student_kexiao WHERE 1=1");
        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }

        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("class_id"));
                return 1;
            }
        });

        return result;
    }


    @Override
    public List<OrgStudentKexiaoRecord> listByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();

        if (classIds != null) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<Long> listIdsByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.tx_org_student_kexiao WHERE 1=1");

        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<Long> pageDistinctUserId(Long orgId, Collection<Long> userIds, Date startTime, Date endTime, PageDto pageDto) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(user_id) FROM yunying.tx_org_student_kexiao WHERE 1=1");

        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }

        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }

        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("user_id"));
                return 1;
            }
        });

        return result;
    }


    @Override
    public List<OrgStudentKexiaoRecord> listByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();

        builder.eq("orgId", orgId);
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<OrgStudentKexiaoRecord> listByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();

        if (orgIds != null) {
            builder.in("orgId", orgIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public Map<Long, Map<Integer, ChargeUnitStatisticDto>> mapOrgChargeUnitStatisticDto(Collection<Long> orgIds, Date startTime, Date endTime) {
        final Map<Long, Map<Integer, ChargeUnitStatisticDto>> result = new HashMap<Long, Map<Integer, ChargeUnitStatisticDto>>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT org_id, charge_unit, sum(lesson_duration) AS lesson_duration_minute, sum(round(lesson_duration/60,2)) AS lesson_duration_hour, sum(amount) AS amount, count(id) AS line_count FROM yunying.tx_org_student_kexiao WHERE 1=1");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.append(" AND org_id IN (:orgIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }
        builder.append(" GROUP BY org_id,charge_unit");


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", orgIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Map<Integer, ChargeUnitStatisticDto> data = null;
            ChargeUnitStatisticDto dto = null;
            Long orgId = null;
            Integer chargeUnit = null;
            Integer lessonDurationMinute;
            Double lessonDurationHour;
            Long amount = null;
            Integer lineCount = null;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                orgId = rs.getLong("org_id");
                chargeUnit = rs.getInt("charge_unit");
                lessonDurationMinute = rs.getInt("lesson_duration_minute");
                lessonDurationHour = rs.getDouble("lesson_duration_hour");
                amount = rs.getLong("amount");
                lineCount = rs.getInt("line_count");

                data = result.get(orgId);
                if (data == null) {
                    data = new HashMap<Integer, ChargeUnitStatisticDto>();
                    result.put(orgId, data);
                }

                dto = new ChargeUnitStatisticDto();
                dto.setAmount(amount);
                dto.setChargeUnit(chargeUnit);
                dto.setLessonDurationMinute(lessonDurationMinute);
                dto.setLessonDurationHour(lessonDurationHour);
                dto.setLineCount(lineCount);
                data.put(chargeUnit, dto);
                return 1;
            }
        });

        return result;
    }

    @Override
    public Map<Long, Map<Integer, ChargeUnitStatisticDto>> mapClassChargeUnitStatisticDto(Collection<Long> classIds, Date startTime, Date endTime) {
        final Map<Long, Map<Integer, ChargeUnitStatisticDto>> result = new HashMap<Long, Map<Integer, ChargeUnitStatisticDto>>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT class_id, charge_unit, sum(lesson_duration) AS lesson_duration_minute, sum(round(lesson_duration/60,2)) AS lesson_duration_hour, sum(amount) AS amount, count(id) AS line_count FROM yunying.tx_org_student_kexiao WHERE 1=1");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }
        builder.append(" GROUP BY class_id,charge_unit");


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Map<Integer, ChargeUnitStatisticDto> data = null;
            ChargeUnitStatisticDto dto = null;
            Long classId = null;
            Integer chargeUnit = null;
            Integer lessonDurationMinute;
            Double lessonDurationHour;
            Long amount = null;
            Integer lineCount = null;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                classId = rs.getLong("class_id");
                chargeUnit = rs.getInt("charge_unit");
                lessonDurationMinute = rs.getInt("lesson_duration_minute");
                lessonDurationHour = rs.getDouble("lesson_duration_hour");
                amount = rs.getLong("amount");
                lineCount = rs.getInt("line_count");

                data = result.get(classId);
                if (data == null) {
                    data = new HashMap<Integer, ChargeUnitStatisticDto>();
                    result.put(classId, data);
                }

                dto = new ChargeUnitStatisticDto();
                dto.setAmount(amount);
                dto.setChargeUnit(chargeUnit);
                dto.setLessonDurationMinute(lessonDurationMinute);
                dto.setLessonDurationHour(lessonDurationHour);
                dto.setLineCount(lineCount);
                data.put(chargeUnit, dto);
                return 1;
            }
        });

        return result;
    }

    @Override
    public Map<Long, Map<Integer, ChargeUnitStatisticDto>> mapUserChargeUnitStatisticDto(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        final Map<Long, Map<Integer, ChargeUnitStatisticDto>> result = new HashMap<Long, Map<Integer, ChargeUnitStatisticDto>>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT user_id, charge_unit, sum(lesson_duration) AS lesson_duration_minute, sum(round(lesson_duration/60,2)) AS lesson_duration_hour, sum(amount) AS amount, count(id) AS line_count FROM yunying.tx_org_student_kexiao WHERE 1=1");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }
        builder.append(" GROUP BY user_id,charge_unit");


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Map<Integer, ChargeUnitStatisticDto> data = null;
            ChargeUnitStatisticDto dto = null;
            Long userId = null;
            Integer chargeUnit = null;
            Long amount = null;
            Integer lineCount = null;
            Integer lessonDurationMinute;
            Double lessonDurationHour;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                userId = rs.getLong("user_id");
                chargeUnit = rs.getInt("charge_unit");
                lessonDurationMinute = rs.getInt("lesson_duration_minute");
                lessonDurationHour = rs.getDouble("lesson_duration_hour");
                amount = rs.getLong("amount");
                lineCount = rs.getInt("line_count");

                data = result.get(userId);
                if (data == null) {
                    data = new HashMap<Integer, ChargeUnitStatisticDto>();
                    result.put(userId, data);
                }

                dto = new ChargeUnitStatisticDto();
                dto.setAmount(amount);
                dto.setChargeUnit(chargeUnit);
                dto.setLessonDurationMinute(lessonDurationMinute);
                dto.setLessonDurationHour(lessonDurationHour);
                dto.setLineCount(lineCount);
                data.put(chargeUnit, dto);
                return 1;
            }
        });

        return result;
    }

    @Override
    public Map<Integer, ChargeUnitStatisticDto> mapOrgKexiaoListDtoData(Collection<Long> orgIds, Date startTime, Date endTime) {
        final Map<Integer, ChargeUnitStatisticDto> result = new HashMap<Integer, ChargeUnitStatisticDto>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT charge_unit, sum(lesson_duration) AS lesson_duration_minute, sum(round(lesson_duration/60,2)) AS lesson_duration_hour, sum(amount) AS amount, count(id) AS line_count FROM yunying.tx_org_student_kexiao WHERE 1=1");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.append(" AND org_id IN (:orgIds)");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }
        builder.append(" GROUP BY charge_unit");


        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", orgIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {

            ChargeUnitStatisticDto dto = null;
            Integer chargeUnit = null;
            Integer lessonDurationMinute;
            Double lessonDurationHour;
            Long amount = null;
            Integer lineCount = null;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                chargeUnit = rs.getInt("charge_unit");
                lessonDurationMinute = rs.getInt("lesson_duration_minute");
                lessonDurationHour = rs.getDouble("lesson_duration_hour");
                amount = rs.getLong("amount");
                lineCount = rs.getInt("line_count");

                dto = new ChargeUnitStatisticDto();
                dto.setAmount(amount);
                dto.setChargeUnit(chargeUnit);
                dto.setLessonDurationMinute(lessonDurationMinute);
                dto.setLessonDurationHour(lessonDurationHour);
                dto.setLineCount(lineCount);
                result.put(chargeUnit, dto);
                return 1;
            }
        });

        return result;
    }

    @Override
    public KexiaoSumDto getKexiaoKexiaoSumDto(Collection<Long> orgIds, Collection<Long> classIds, Collection<Long> userIds, Integer chargeUnit, Date startTime, Date endTime) {
        final KexiaoSumDto dto = new KexiaoSumDto();
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT sum(amount) AS amount, sum(lesson_duration) AS lesson_duration_minute, sum(round(lesson_duration/60,2)) AS lesson_duration_hour, count(id) AS line_count FROM yunying.tx_org_student_kexiao WHERE 1=1");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            if (orgIds.size() == 1) {
                builder.append(" AND org_id=:orgIds");
                params.put("orgIds", orgIds.toArray()[0]);
            } else {
                builder.append(" AND org_id IN (:orgIds)");
                params.put("orgIds", orgIds);
            }

        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            if (classIds.size() == 1) {
                builder.append(" AND class_id=:classIds");
                params.put("classIds", classIds.toArray()[0]);
            } else {
                builder.append(" AND class_id IN (:classIds)");
                params.put("classIds", classIds);
            }
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            if (userIds.size() == 1) {
                builder.append(" AND user_id=:userIds");
                params.put("userIds", userIds.toArray()[0]);
            } else {
                builder.append(" AND user_id IN (:userIds)");
                params.put("userIds", userIds);
            }
        }
        if (chargeUnit != null) {
            builder.append(" AND charge_unit =:chargeUnit");
        }
        if (startTime != null) {
            builder.append(" AND start_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND start_time<=:endTime");
        }

        params.put("chargeUnit", chargeUnit);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                Integer times = rs.getInt("line_count");
                Integer lessonDurationMinute = rs.getInt("lesson_duration_minute");
                Double lessonDurationHour = rs.getDouble("lesson_duration_hour");
                Long amount = rs.getLong("amount");

                if (times != null) {
                    dto.setSumKexiaoTimes(times);
                }
                if (lessonDurationMinute != null) {
                    dto.setSumKexiaoMinute(lessonDurationMinute);
                }
                if (lessonDurationHour != null) {
                    dto.setSumKexiaoHour(lessonDurationHour);
                }
                if (amount != null) {
                    dto.setSumKexiaoMoney(amount);
                }
                return 1;
            }
        });

        return dto;
    }

    @Override
    public List<OrgStudentKexiaoRecord> pageByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime, PageDto pageDto) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();

        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }

        return queryList(builder);
    }

    @Override
    public Integer countByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();
        builder.count("id");

        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("startTime", startTime);
        }
        if (endTime != null) {
            builder.le("startTime", endTime);
        }

        Integer count = queryForObject(builder, Integer.class);
        return count != null ? count : 0;
    }

    @Override
    public List<OrgStudentKexiaoRecord> listOrderByStartTime(List<Long> ids) {
        SingleSqlBuilder<OrgStudentKexiaoRecord> builder = createSqlBuilder();
        builder.in("id", ids);
        builder.desc("startTime");
        return queryList(builder);
    }


}
