package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.WxNews;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 新闻
 * Created by wangsixia on 2017/1/13.
 */
public interface WxNewsDao extends CommonDao<WxNews> {

    /**
     * 获取新闻列表
     * @param orgId 机构id
     * @param ids 新闻ids
     * @param categoryId 分类id
     * @param key 搜索(标题)关键字
     * @param status 发布状态 PublishStatus: 0未发布;1已发布
     * @param start 查询起始时间
     * @param end 查询结束时间
     * @param pageDto
     * @param queryProps
     * @return
     */
    List<WxNews> getListByParam (Long orgId, Collection<Long> ids, Long categoryId, String key, Integer status, Date start, Date end, Boolean descByPublish, PageDto pageDto, String...queryProps);

    /**
     * 查询新闻详情
     * @param orgId
     * @param id
     * @param status 发布状态 PublishStatus: 0未发布;1已发布
     * @param queryProps
     * @return
     */
    WxNews getById(Long orgId, Long id, Integer status, String...queryProps);
}
