/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomRecordDao;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class WxLiveRoomRecordDaoImpl
extends JdbcTemplateDaoSupport<WxLiveRoomRecord>
implements WxLiveRoomRecordDao {
    @Override
    public List<WxLiveRoomRecord> querySumGroupByOrg(Date startTime, Date endTime) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[]{"orgId", "queryTime"});
        sqlBuilder.sum("num", "num");
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        sqlBuilder.le("queryTime", (Serializable)endTime);
        sqlBuilder.isNotNull("roomId");
        sqlBuilder.groupByNames(new String[]{"orgId", "queryTime"});
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<WxLiveRoomRecord> querySumByOrg(Long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[]{"orgId", "queryTime"});
        sqlBuilder.sum("num", "num");
        sqlBuilder.eq("orgId", (Serializable)orgId);
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        sqlBuilder.le("queryTime", (Serializable)endTime);
        sqlBuilder.isNotNull("roomId");
        sqlBuilder.groupByNames(new String[]{"queryTime"});
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<WxLiveRoomRecord> queryDailyOrgNum(Long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("orgId", (Serializable)orgId);
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        sqlBuilder.le("queryTime", (Serializable)endTime);
        sqlBuilder.eq("roomId", (Serializable)Integer.valueOf(0));
        sqlBuilder.addOrder(Order.asc((String[])new String[]{"createTime", "queryTime"}));
        return this.queryList(sqlBuilder);
    }

    @Override
    public WxLiveRoomRecord getOrgTodayMaxNumRecord(Long orgId) {
        Date now = new Date();
        Date startTime = DateUtil.getStartOfDay((Date)now);
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[]{"orgId", "queryTime"});
        sqlBuilder.max("num", "num");
        sqlBuilder.eq("orgId", (Serializable)orgId);
        sqlBuilder.eq("roomId", (Serializable)Integer.valueOf(0));
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        return (WxLiveRoomRecord)this.uniqueResult(sqlBuilder);
    }

    @Override
    public WxLiveRoomRecord getOrgMonthMaxNumRecord(Long orgId) {
        Date now = new Date();
        Date startTime = DateUtil.getFirstDate((Date)now);
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[]{"orgId", "queryTime"});
        sqlBuilder.max("num", "num");
        sqlBuilder.eq("orgId", (Serializable)orgId);
        sqlBuilder.eq("roomId", (Serializable)Integer.valueOf(0));
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        return (WxLiveRoomRecord)this.uniqueResult(sqlBuilder);
    }

    @Override
    public int delOrgMaxRecordByTime(Date startTime, Date endTime) {
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.ge("queryTime", (Serializable)startTime);
        sqlBuilder.le("queryTime", (Serializable)endTime);
        sqlBuilder.eq("roomId", (Serializable)Integer.valueOf(0));
        return this.delete(sqlBuilder);
    }
}

