/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TtsSmsDaoImpl
extends JdbcTemplateDaoSupport<TtsSms>
implements TtsSmsDao {
    public TtsSmsDaoImpl() {
        super(TtsSms.class);
    }

    @Override
    public Integer getTtsSmsTotal(Integer orgId, Integer userRole, Integer sendResult, String startDate, String endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)orgId);
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (sendResult != null) {
            builder.eq("sendResult", (Serializable)sendResult);
        }
        if (startDate != null && endDate != null) {
            builder.between("createTime", (Comparable)((Object)startDate), (Comparable)((Object)endDate));
        }
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, Integer> getOrgTtsSmsCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        String sql = "select count(1) as count,user_id as org_id from tts.tts_sms where user_role = 6 and user_id in (:orgIds)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startTime);
            param.put("endDate", endTime);
        }
        sql = sql + " GROUP BY user_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}

