/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.LessonSignAudit;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgLessonSignDaoImpl
extends JdbcTemplateDaoSupport<OrgLessonSign>
implements OrgLessonSignDao {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSignDaoImpl.class);

    public OrgLessonSignDaoImpl() {
        super(OrgLessonSign.class);
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(Long orgId, Long courseId, Long userId) {
        String sql = "select distinct ocl.id as lesson_id, ocl.org_id, ocl.number as `index`, ols.status from tts.org_class_lesson ocl join tts.org_student_lesson osl ON (osl.lesson_id = ocl.id and osl.org_id = :orgId) left join tts.org_lesson_sign ols ON (ocl.id = ols.lesson_id and ols.user_id = :userId and user_role = 2) where ocl.org_id = :orgId and ocl.course_id = :courseId and osl.student_id = :userId and osl.del_status=0 order by ocl.number asc";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseId", courseId);
        paramMap.put("userId", userId);
        return this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new BeanPropertyRowMapper(OrgLessonSign.class));
    }

    @Override
    public Map<Long, Integer> querySignedLessonStudentCountMap(Long orgId, Collection<Long> lessonIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder("SELECT count(sign.user_id) AS numOfUser,sign.lesson_id AS lessonId ");
        sb.append("FROM tts.org_lesson_sign sign LEFT JOIN tts.org_student_lesson lesson ");
        sb.append("ON sign.lesson_id=lesson.lesson_id AND sign.user_id=lesson.student_id ");
        sb.append("WHERE sign.org_id=:orgId AND lesson.org_id=:orgId ");
        params.put("orgId", orgId);
        sb.append("AND sign.lesson_id IN (:lessonIds) ");
        params.put("lessonIds", lessonIds);
        sb.append("AND sign.user_role=:userRole ");
        params.put("userRole", UserRoleEnum.STUDENT.getCode());
        sb.append("AND sign.status=:status ");
        params.put("status", SignStatus.SIGNED.getCode());
        sb.append("AND lesson.del_status=:delStatus ");
        params.put("delStatus", DeleteStatus.NORMAL.getValue());
        sb.append("GROUP BY sign.lesson_id ");
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("lessonId"), rs.getInt("numOfUser"));
            }
        });
        return result;
    }

    @Override
    public Map<Long, Integer> querySignLessonStudentCountMap(Long orgId, Collection<Long> lessonIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        HashMap params = Maps.newHashMap();
        StringBuilder sb = new StringBuilder("SELECT count(sign.user_id) AS numOfUser,sign.lesson_id AS lessonId ");
        sb.append("FROM tts.org_lesson_sign sign LEFT JOIN tts.org_student_lesson lesson ");
        sb.append("ON sign.lesson_id=lesson.lesson_id AND sign.user_id=lesson.student_id ");
        sb.append("WHERE sign.org_id=:orgId AND lesson.org_id=:orgId ");
        params.put("orgId", orgId);
        sb.append("AND sign.lesson_id IN (:lessonIds) ");
        params.put("lessonIds", lessonIds);
        sb.append("AND sign.user_role=:userRole ");
        params.put("userRole", UserRoleEnum.STUDENT.getCode());
        sb.append("AND sign.status>:status ");
        params.put("status", SignStatus.UNSIGN.getCode());
        sb.append("AND lesson.del_status=:delStatus ");
        params.put("delStatus", DeleteStatus.NORMAL.getValue());
        sb.append("GROUP BY sign.lesson_id ");
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("lessonId"), rs.getInt("numOfUser"));
            }
        });
        return result;
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(final Long orgId, final Long courseId, Collection<Long> lessonIds, final String ... queryProps) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgLessonSign>>(){

            public List<OrgLessonSign> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(queryProps);
                if (orgId != null) {
                    builder.eq("orgId", (Serializable)orgId);
                }
                if (courseId != null) {
                    builder.eq("courseId", (Serializable)courseId);
                }
                builder.in("lessonId", querySet);
                builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
                return OrgLessonSignDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(Long orgId, Long lessonId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getStudentLessonByStatus(Long orgId, Long lessonId, int status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(SignStatus.UNSIGN.getCode()));
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getLessonSignList(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole, Integer status, boolean withUnsign, Date beginTime, Date endTime, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        if (courseId != null) {
            builder.eq("courseId", (Serializable)courseId);
        }
        if (lessonId != null) {
            builder.eq("lessonId", (Serializable)lessonId);
        }
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (beginTime != null) {
            builder.ge("createTime", (Serializable)beginTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        if (!withUnsign) {
            builder.ne("status", (Serializable)Integer.valueOf(SignStatus.UNSIGN.getCode()));
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getUserLessonSignList(final Long orgId, Collection<Long> userIds, final Long courseId, final Integer userRole, final Integer status, final String ... props) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgLessonSign>>(){

            public List<OrgLessonSign> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                if (props != null) {
                    builder.select(props);
                }
                builder.in("userId", querySet);
                if (status != null) {
                    builder.eq("status", (Serializable)status);
                }
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("courseId", (Serializable)courseId);
                builder.eq("userRole", (Serializable)userRole);
                builder.asc("createTime");
                return OrgLessonSignDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgLessonSignCount(Collection<Long> lessonIds, final Integer userRole) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.count("id", "signCount");
                builder.in("lessonId", lessonIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.group("userId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public void orgLessonSignBatchEdit(Long lessonId, Collection<Long> userIds, Integer status, @NonNull Long cascadeId, @NonNull Integer source) {
        if (cascadeId == null) {
            throw new NullPointerException("cascadeId");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"status is illegal");
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String sql = "update tts.org_lesson_sign set status = :status, cascade_Id=:cascadeId, source=:source where lesson_id = :lessonId  AND  user_id in (:userId)";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", status);
        params.put("userId", userIds);
        params.put("lessonId", lessonId);
        params.put("cascadeId", cascadeId);
        params.put("source", source);
        log.debug("batch sign sql:{},params:{}", (Object)sql, params);
        this.getNamedJdbcTemplate().update(sql, params);
    }

    @Override
    public void orgLessonSignBatchEdit(Collection<Long> lessonIds, Collection<Long> userIds, Integer status, @NonNull Long cascadeId, @NonNull Integer source) {
        if (cascadeId == null) {
            throw new NullPointerException("cascadeId");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(lessonIds), (Object)"lessonIds is empty");
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"status is illegal");
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String sql = "update tts.org_lesson_sign set status = :status, cascade_Id=:cascadeId, source=:source where lesson_id in (:lessonIds)  AND  user_id in (:userId) ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", status);
        params.put("userId", userIds);
        params.put("lessonIds", lessonIds);
        params.put("cascadeId", cascadeId);
        params.put("source", source);
        log.debug("batch sign sql:{},params:{}", (Object)sql, params);
        this.getNamedJdbcTemplate().update(sql, params);
    }

    @Override
    public List<OrgLessonSign> getStudentSign(Long orgId, Long userId, Integer userRole, Collection<Long> lessonIds, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        Preconditions.checkArgument((userRole != null && userRole > 0 ? 1 : 0) != 0, (Object)"userRole is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("lessonId", lessonIds);
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getOrgSignCount(Collection<Long> orgIds, Long userId, final Integer userRole) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> orgIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("id", "signCount");
                builder.in("orgId", orgIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.group("orgId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("orgId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgCourseSignCount(Collection<Long> courseIds, final Long userId, final Integer userRole) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> courseIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("id", "signCount");
                builder.in("courseId", courseIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.eq("userId", (Serializable)userId);
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgCourseStudentSignCount(Long orgId, Collection<Long> userIds, final Long courseId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> userIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.count("id", "signCount");
                builder.eq("orgId", (Serializable)((Object)"orgId"));
                builder.in("userId", userIds);
                builder.ge("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
                builder.eq("courseId", (Serializable)courseId);
                builder.group("userId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public OrgLessonSign getStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (courseId != null) {
            builder.eq("courseId", (Serializable)courseId);
        }
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        return (OrgLessonSign)this.uniqueResult(builder);
    }

    @Override
    public List<OrgLessonSign> getLessonStudentIds(Long orgId, Long lessonId, Collection<Long> userIds, Integer sign, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (lessonId != null) {
            builder.eq("lessonId", (Serializable)lessonId);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (sign != null) {
            builder.eq("status", (Serializable)sign);
        }
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryList(builder);
    }

    @Override
    public boolean isStudentSignInLesson(Long orgId, Long lessonId, Long userId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        builder.gt("status", (Serializable)Integer.valueOf(SignStatus.UNSIGN.getCode()));
        Long id = (Long)this.queryForObject(builder, Long.class);
        return id != null;
    }

    @Override
    public Map<Long, Integer> getCourseSignCountMap(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        String sql = "select ocl.course_id as courseId,count(ols.id) as cnt from tts.org_lesson_sign ols right join tts.org_class_lesson ocl on ocl.id = ols.lesson_id where ocl.start_time < :now and ocl.org_id = :orgId and ocl.course_id in (:courseIds) and ols.status = 1 group by ocl.course_id order by field(courseId,:courseIds)";
        final HashMap resultMap = Maps.newHashMap();
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseIds", courseIds);
        paramMap.put("now", new Date());
        log.debug("sql = {},param = {}", (Object)sql, (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                resultMap.put(rs.getLong("courseId"), rs.getInt("cnt"));
            }
        });
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getStudentSignCountMap(Long orgId, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        String sql = "select ols.user_id as userId, count(ols.id) as cnt from tts.org_lesson_sign ols where  ols.org_id = :orgId and ols.user_id in(:userIds) and ols.user_role = 2 group by ols.user_id order by field(userId,:userIds)";
        final HashMap resultMap = Maps.newHashMap();
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userIds", userIds);
        log.debug("sql = {},param = {}", (Object)sql, (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                resultMap.put(rs.getLong("userId"), rs.getInt("cnt"));
            }
        });
        return resultMap;
    }

    @Override
    public Map<Long, LessonSignAudit> queryLessonSignAudit(Long orgId, Collection<Long> lessonIds) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("lessonId", lessonIds);
        StringBuilder sb = new StringBuilder();
        sb.append("select s.lesson_id id, count(case when s.status = 1 then 1 else null end) signCount, ").append("count(case when s.status=2 then 1 else null end) leaveCount, ").append("count(case when s.status =3 then 1 else null end) absentCount ").append("from tts.org_lesson_sign s ").append("where s.org_id =:orgId ").append("and s.lesson_id in(:lessonId) group by s.lesson_id");
        final HashMap map = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                LessonSignAudit lesson = new LessonSignAudit();
                lesson.setLessonId(rs.getLong("id"));
                lesson.setSignCount(rs.getInt("signCount"));
                lesson.setLeaveCount(rs.getInt("leaveCount"));
                lesson.setAbsentCount(rs.getInt("absentCount"));
                map.put(lesson.getLessonId(), lesson);
            }
        });
        return map;
    }

    @Override
    public Map<Long, Integer> getOrgSignLessonTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(distinct(lesson_id)) count from tts.org_lesson_sign where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startTime and :endTime";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgSignStudentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from tts.org_lesson_sign where user_role = 2 and status = 1 and org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " AND create_time between :startTime and :endTime";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgLessonSign> getOrgClassLesson(List<Long> TianxiaoOrgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userRole", (Serializable)Integer.valueOf(2));
        builder.in("orgId", TianxiaoOrgIds);
        return this.queryList(builder);
    }

    @Override
    public Map<String, Integer> getOrgSignMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds, Integer userRole) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("userRole", userRole);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        String sql = "SELECT count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' FROM tts.org_lesson_sign where user_role = :userRole and status = 1 and org_id in (:orgIds) and create_time>=:startTime and create_time<=:endTime";
        sql = sql + " group by MONTH(create_time),DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String date = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    log.info("createTime===========" + rs.getString("createTime") + "count==========" + count);
                    map.put(date, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<String, List<Long>> getOrgSignLessonIdsMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        String sql = "SELECT lesson_id, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' FROM tts.org_lesson_sign where  status = 1 and org_id in (:orgIds) and create_time>=:startTime and create_time<=:endTime group by lesson_id, MONTH(create_time),DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, List<Long>>>(){

            public Map<String, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
                while (rs.next()) {
                    String createTime = rs.getString("createTime");
                    Long lessonId = rs.getLong("lesson_id");
                    ArrayList<Long> lessonIds = (ArrayList<Long>)map.get(createTime);
                    if (GenericsUtils.isNullOrEmpty((Object)lessonIds)) {
                        lessonIds = new ArrayList<Long>();
                        map.put(createTime, lessonIds);
                    }
                    lessonIds.add(lessonId);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgLessonSign> getCourseLessonSignIn(List<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return new ArrayList<OrgLessonSign>();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        builder.in("courseId", courseIds);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<Integer>> getOrgCourseStudentSignMap(Collection<Long> userIds, final Long courseId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, List<Integer>>>(){

            public Map<Long, List<Integer>> doQuery(Collection<Long> userIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[]{"userId", "status"});
                builder.in("userId", userIds);
                builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
                builder.eq("courseId", (Serializable)courseId);
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        Long userId = rs.getLong("userId");
                        List statusList = (List)result.get(userId);
                        if (statusList == null) {
                            statusList = Lists.newArrayList();
                            result.put(userId, statusList);
                        }
                        statusList.add(rs.getInt("status"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public int getVipLessonSignCount(Long orgId, Long courseId, int ruleValue) {
        HashSet<Integer> set;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        if (ruleValue == 1) {
            builder.eq("status", (Serializable)Integer.valueOf(1));
        }
        if (ruleValue == 3) {
            set = new HashSet<Integer>();
            set.add(1);
            set.add(2);
            builder.in("status", set);
        }
        if (ruleValue == 5) {
            set = new HashSet();
            set.add(1);
            set.add(3);
            builder.in("status", set);
        }
        if (ruleValue == 7) {
            set = new HashSet();
            set.add(1);
            set.add(2);
            set.add(3);
            builder.in("status", set);
        }
        return this.queryList(builder).size();
    }

    @Override
    public List<OrgLessonSign> getByCourseIdsAndUserIdsAndStatus(Long orgId, Collection<Long> courseIds, Collection<Long> userIds, Integer status, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (null != status) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getByOrgIdCourseIdLessonIdsStudentIds(@NonNull Long orgId, Long courseId, List<Long> lessonIds, List<Long> userIds, String ... props) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        if (null != orgId) {
            builder.eq("orgId", (Serializable)orgId);
        }
        if (null != courseId) {
            builder.eq("courseId", (Serializable)courseId);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getByStudentLessonIds(Collection<Long> stuLessonIds, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("lessonId", stuLessonIds);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> mapKeyLessonIdValueStatus(Long orgId, Long userId) {
        final HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        String sql = "select lesson_id,status from tts.org_lesson_sign where org_id=:orgId AND user_id=:userId";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("orgId", orgId);
        params.put("userId", userId);
        template.query(sql, params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("lesson_id"), rs.getInt("status"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Integer, Integer> mapKeyStatusValueCount(Collection<Long> lessonIds, Long userId) {
        final HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t1.status,count(*) AS num FROM tts.org_student_lesson t2 INNER JOIN tts.org_lesson_sign t1 ON t1.lesson_id=t2.lesson_id AND t1.user_id=t2.student_id ");
        sql.append(" WHERE t2.del_status=0 AND t1.lesson_id IN (:lessonIds) ");
        if (userId != null) {
            sql.append(" AND t2.student_id=:userId ");
        }
        sql.append(" GROUP BY t1.status");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lessonIds", lessonIds);
        params.put("userId", userId);
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getInt("status"), rs.getInt("num"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Long, Integer> mapKeyLessonIdValueCount(Collection<Long> lessonIds) {
        final HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT t1.lesson_id,count(*) AS num FROM tts.org_student_lesson t2 INNER JOIN tts.org_lesson_sign t1 ON t1.lesson_id=t2.lesson_id AND t1.user_id=t2.student_id");
        builder.append(" WHERE t2.del_status=0 AND t1.lesson_id IN (:lessonIds) ");
        builder.append(" GROUP BY t1.lesson_id");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("lessonIds", lessonIds);
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("lesson_id"), rs.getInt("num"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<Long, Map<Long, Map<Integer, Integer>>> mapStudentSignStatus(Collection<Long> lessonIds) {
        final HashMap<Long, Map<Long, Map<Integer, Integer>>> result = new HashMap<Long, Map<Long, Map<Integer, Integer>>>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t2.course_id, t2.student_id, t1.status,count(*) AS num FROM tts.org_student_lesson t2 INNER JOIN tts.org_lesson_sign t1 ON t1.lesson_id=t2.lesson_id AND t1.user_id=t2.student_id ");
        sql.append(" WHERE t2.del_status=0 AND t1.lesson_id IN (:lessonIds) ");
        sql.append(" GROUP BY t2.course_id, t2.student_id, t1.status");
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("lessonIds", lessonIds);
        template.query(sql.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<Integer, Integer> signStatusMap;
                Long courseId = rs.getLong("course_id");
                Long stuUserId = rs.getLong("student_id");
                Integer status = rs.getInt("status");
                Integer num = rs.getInt("num");
                HashMap<Long, HashMap<Integer, Integer>> stuSignStatusMap = (HashMap<Long, HashMap<Integer, Integer>>)result.get(courseId);
                if (stuSignStatusMap == null) {
                    stuSignStatusMap = new HashMap<Long, HashMap<Integer, Integer>>();
                    result.put(courseId, stuSignStatusMap);
                }
                if ((signStatusMap = (HashMap<Integer, Integer>)stuSignStatusMap.get(stuUserId)) == null) {
                    signStatusMap = new HashMap<Integer, Integer>();
                    stuSignStatusMap.put(stuUserId, signStatusMap);
                }
                signStatusMap.put(status, num);
                return 1;
            }
        });
        return result;
    }

    @Override
    public List<OrgLessonSign> listByPage(Date startTime, Date endTime, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null) {
            builder.ge("updateTime", (Serializable)startTime);
            builder.le("updateTime", (Serializable)endTime);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }
}

