/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgTeacherLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgTeacherLesson>
implements OrgTeacherLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherLessonDaoImpl.class);

    public OrgTeacherLessonDaoImpl() {
        super(OrgTeacherLesson.class);
    }

    @Override
    public List<OrgTeacherLesson> queryTeacherLessons(Long orgId, Collection<Long> teacherIds, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            builder.in("teacherId", teacherIds);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Long> queryLessonTeacherIdMap(final Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgTeacherLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select("teacherId");
                builder.select("lessonId");
                if (orgId != null) {
                    builder.eq("orgId", (Serializable)orgId);
                }
                builder.in("lessonId", querySet);
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("query lessonTeacher id map sql:{}, params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgTeacherLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getLong("teacherId"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<Long> getUserIds(Long lessonId, Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("teacherId");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> queryTeacherLessons(Long orgId, Long teacherId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("teacherId", (Serializable)teacherId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public boolean isTeacherInLesson(Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("teacherId", (Serializable)userId);
        List list = this.queryForList(builder, Long.class);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public OrgTeacherLesson getByLessonId(Long orgId, Long lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (OrgTeacherLesson)list.get(0);
        }
        return null;
    }

    @Override
    public Map<Long, List<Long>> getTeacherLessonByStartTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId, teacher.teacher_id as teacherId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("teacherId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(userId)) {
                    result.put(userId, Lists.newArrayList());
                }
                ((List)result.get(userId)).add(lessonId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<Long>> getTeacherLessonByEndTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select teacher.lesson_id as lessonId, teacher.teacher_id as teacherId from tts.org_teacher_lesson teacher ");
        sb.append("join tts.org_class_lesson lesson on teacher.lesson_id = lesson.id ");
        sb.append(" and lesson.end_time >=:startTime and lesson.end_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("teacherId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }
}

