/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseSmsDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseSms>
implements OrgCourseSmsDao {
    public OrgCourseSmsDaoImpl() {
        super(OrgCourseSms.class);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(Long orgId, Long courseId, Integer userRole, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgCourseSms> getOrgCourseSmsList(final Long orgId, Collection<Long> courseIds, final Integer userRole, final String ... queryProps) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseSms>>(){

            public List<OrgCourseSms> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseSmsDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                if (userRole != null) {
                    builder.eq("userRole", (Serializable)userRole);
                }
                return OrgCourseSmsDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgCourseSms getOrgCourseSms(Long orgId, Long courseId, Integer userRole, Long userId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("userId", (Serializable)userId);
        return (OrgCourseSms)this.uniqueResult(builder);
    }

    @Override
    public void increaseSendTime(Long orgId, Long courseId, Integer userRole, Long userId) {
        OrgCourseSms sms = this.getOrgCourseSms(orgId, courseId, userRole, userId, new String[0]);
        if (sms != null) {
            sms.setSend(sms.getSend() == null ? 1 : sms.getSend() + 1);
        }
        this.update(sms, new String[]{"send"});
    }

    @Override
    public void setViewStatus(Long id, Integer viewStatus) {
        OrgCourseSms sms = (OrgCourseSms)this.getById(id, new String[]{"id", "viewStatus"});
        if (sms != null) {
            sms.setViewStatus(viewStatus);
        }
        this.update(sms, new String[]{"send"});
    }

    @Override
    public void delCourseSmsRecord(Long orgId, Long courseId, Integer userRole, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((userRole != null ? 1 : 0) != 0, (Object)"userRole is illegal");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"userId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("userRole", (Serializable)userRole);
        builder.in("userId", userIds);
        this.delete(builder);
    }
}

