/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgStudentLesson>
implements OrgStudentLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentLessonDaoImpl.class);

    public OrgStudentLessonDaoImpl() {
        super(OrgStudentLesson.class);
    }

    @Override
    public void delStudentFromLesson(Long orgId, Collection<Long> lessonIds, Long userId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return;
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("userId", userId);
        this.delByCondition(condition);
    }

    @Override
    public List<Long> getLessIdsOfStudent(final Long orgId, Collection<Long> lessonIds, final Long userId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.in("lessonId", querySet);
                builder.eq("userId", (Serializable)userId);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<Long> getUserIds(Long lessonId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, List<Long>> getStudentCount(Collection<Long> lessonIds, final Long orgId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("lessonIds = {}", lessonIds);
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.in("lessonId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<Long, Integer> queryLessonStudentCountMap(final Long orgId, Collection<Long> lessonIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("userId", "studentCount");
                builder.eq("orgId", (Serializable)orgId);
                builder.in("lessonId", lessonIds);
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("query lesson student count sql:{} params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgStudentLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("studentCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Integer queryLessonStudentCount(Long orgId, Long lessonId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.distinctCount("userId", "studentCount");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer queryLessonStudentCount(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return 0;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.in("lessonId", lessonIds);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getLessonIdsOfStudent(Long orgId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Integer getStudentLessonCountToday(Long orgId, Long userId) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userId", userId);
        paramMap.put("startTime", DateUtil.getCurrentDate());
        paramMap.put("endTime", DateUtil.getDayDiff((int)1));
        String sql = "select count(ocl.id) from tts.org_student_lesson osl join tts.org_class_lesson ocl on osl.lesson_id = ocl.id where ocl.org_id = :orgId AND ocl.start_time > :startTime AND ocl.end_time <= :endTime AND osl.student_id = :userId";
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Integer.class);
    }

    @Override
    public boolean isStudentInlesson(Long lessonId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        List list = this.queryForList(builder, Long.class);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public Map<Long, Integer> getStudentLessonCountOfCourses(Long orgId, Long userId, Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        final HashMap map = Maps.newHashMap();
        String sql = "select count(ocl.id) as cnt,ocl.course_id from tts.org_student_lesson osl join tts.org_class_lesson ocl ON osl.lesson_id = ocl.id where  ocl.org_id = :orgId AND osl.student_id = :userId AND ocl.course_id in(:courseIds) group by(ocl.course_id)";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userId", userId);
        paramMap.put("courseIds", courseIds);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                map.put(rs.getLong("course_id"), rs.getInt("cnt"));
            }
        });
        return map;
    }

    @Override
    public Map<Long, List<Long>> getLessonStudentList(Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudentLesson>>(){

            public List<OrgStudentLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"lessonId", "userId"});
                builder.in("lessonId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgStudentLesson, Long>(){

            public Long apply(OrgStudentLesson arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public List<Long> getUserIdsByLessonIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentLessonDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.in("lessonId", querySet);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                return OrgStudentLessonDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getStudentLessonByStartTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select student.lesson_id as lessonId, student.student_id as userId from tts.org_student_lesson student ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id ");
        sb.append(" and lesson.start_time >=:startTime and lesson.start_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("userId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<Long>> getStudentLessonByEndTime(Date startTime, Date endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("select student.lesson_id as lessonId, student.student_id as userId from tts.org_student_lesson student ");
        sb.append("join tts.org_class_lesson lesson on student.lesson_id = lesson.id ");
        sb.append(" and lesson.end_time >=:startTime and lesson.end_time <:endTime");
        HashMap param = Maps.newHashMap();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        final HashMap result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sb.toString(), (Map)param, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long userId = rs.getLong("userId");
                Long lessonId = rs.getLong("lessonId");
                if (!result.containsKey(lessonId)) {
                    result.put(lessonId, Lists.newArrayList());
                }
                ((List)result.get(lessonId)).add(userId);
            }
        });
        return result;
    }
}

