/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgLessonSignDaoImpl
extends JdbcTemplateDaoSupport<OrgLessonSign>
implements OrgLessonSignDao {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSignDaoImpl.class);

    public OrgLessonSignDaoImpl() {
        super(OrgLessonSign.class);
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(Long orgId, Long courseId, Long userId) {
        String sql = "select distinct ocl.id as lesson_id, ocl.org_id, ocl.number as `index`, ols.status from tts.org_class_lesson ocl join tts.org_student_lesson osl ON (osl.lesson_id = ocl.id and osl.org_id = :orgId) left join tts.org_lesson_sign ols ON (ocl.id = ols.lesson_id and ols.user_id = :userId and user_role = 2) where ocl.org_id = :orgId and ocl.course_id = :courseId and osl.student_id = :userId order by ocl.number asc";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseId", courseId);
        paramMap.put("userId", userId);
        return this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new BeanPropertyRowMapper(OrgLessonSign.class));
    }

    @Override
    public Map<Long, Integer> queryLessonStudentCountMap(final Long orgId, Collection<Long> lessonIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("userId", "studentCount");
                builder.eq("orgId", (Serializable)orgId);
                builder.in("lessonId", lessonIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)Integer.valueOf(UserRoleEnum.STUDENT.getCode()));
                builder.group("lessonId");
                final HashMap result = Maps.newHashMap();
                log.debug("queryLessonStudentCountMap sql:{},params:{} ", (Object)builder.toSql(), (Object)builder.collectConditionValue());
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("studentCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(final Long orgId, Collection<Long> lessonIds, final String ... queryProps) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        return (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgLessonSign>>(){

            public List<OrgLessonSign> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("lessonId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
                return OrgLessonSignDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgLessonSign> getStudentLessonSign(Long orgId, Long lessonId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonSign> getLessonSignList(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole, Integer status, Date beginTime, Date endTime, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        if (courseId != null) {
            builder.eq("courseId", (Serializable)courseId);
        }
        if (lessonId != null) {
            builder.eq("lessonId", (Serializable)lessonId);
        }
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        if (userRole != null) {
            builder.eq("userRole", (Serializable)userRole);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        if (beginTime != null) {
            builder.ge("beginTime", (Serializable)beginTime);
        }
        if (endTime != null) {
            builder.le("endTime", (Serializable)endTime);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getOrgLessonSignCount(Collection<Long> lessonIds, final Integer userRole) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> lessonIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[]{"userId"});
                builder.count("id", "signCount");
                builder.in("lessonId", lessonIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.group("userId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public void orgLessonSignBatchEdit(Long lessonId, Collection<Long> userIds, Integer status) {
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"status is illegal");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(userIds), (Object)"userIds is empty");
        String sql = "update tts.org_lesson_sign set status = :status where user_id in (:userId) AND lesson_id = :lessonId ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", status);
        params.put("userId", userIds);
        params.put("lessonId", lessonId);
        log.debug("batch sign sql:{},params:{}", (Object)sql, params);
        this.getNamedJdbcTemplate().update(sql, params);
    }

    @Override
    public List<OrgLessonSign> getStudentSign(Long orgId, Long userId, Integer userRole, Collection<Long> lessonIds, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        Preconditions.checkArgument((userRole != null && userRole > 0 ? 1 : 0) != 0, (Object)"userRole is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("lessonId", lessonIds);
        }
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getOrgSignCount(Collection<Long> orgIds, Long userId, final Integer userRole) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(orgIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> orgIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("id", "signCount");
                builder.in("orgId", orgIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.group("orgId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("orgId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgCourseSignCount(Collection<Long> courseIds, final Long userId, final Integer userRole) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> courseIds) {
                SingleSqlBuilder builder = OrgLessonSignDaoImpl.this.createSqlBuilder(new String[0]);
                builder.distinctCount("id", "signCount");
                builder.in("courseId", courseIds);
                builder.eq("status", (Serializable)Integer.valueOf(SignStatus.SIGNED.getCode()));
                builder.eq("userRole", (Serializable)userRole);
                builder.eq("userId", (Serializable)userId);
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgLessonSignDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("signCount"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public OrgLessonSign getStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (courseId != null) {
            builder.eq("courseId", (Serializable)courseId);
        }
        builder.eq("userRole", (Serializable)userRole);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        return (OrgLessonSign)this.uniqueResult(builder);
    }

    @Override
    public List<OrgLessonSign> getLessonStudentIds(Long orgId, Long lessonId, Collection<Long> userIds, Integer sign, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        if (lessonId != null) {
            builder.eq("lessonId", (Serializable)lessonId);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (sign != null) {
            builder.eq("status", (Serializable)sign);
        }
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryList(builder);
    }

    @Override
    public boolean isStudentSignInLesson(Long orgId, Long lessonId, Long userId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        builder.gt("status", (Serializable)Integer.valueOf(SignStatus.UNSIGN.getCode()));
        Long id = (Long)this.queryForObject(builder, Long.class);
        return id != null;
    }
}

