/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.po.CommentAudit;
import com.baijia.tianxiao.dal.org.po.OrgLessonComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Function;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgLessonCommentDaoImpl
extends JdbcTemplateDaoSupport<OrgLessonComment>
implements OrgLessonCommentDao {
    public OrgLessonCommentDaoImpl() {
        super(OrgLessonComment.class);
    }

    @Override
    public List<OrgLessonComment> getLessonStudentComments(Long lessonId, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> getLessonTeacherComments(Long lessonId, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.TEACHER.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return this.queryList(builder);
    }

    @Override
    public OrgLessonComment getLessonCommentDetail(Long lessonId, Long userId, Integer userRole, Boolean isSystem, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("userRole", (Serializable)userRole);
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            builder.eq("fromId", (Serializable)userId);
        } else {
            builder.eq("toId", (Serializable)userId);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        return (OrgLessonComment)this.uniqueResult(builder);
    }

    @Override
    public List<OrgLessonComment> getStudentComments(Long orgId, Long userId, Boolean isSystem, PageDto pageDto, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("fromId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.TEACHER.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgLessonComment> getTeacherCommentsOfStudent(Long orgId, Long userId, Boolean isSystem, PageDto pageDto, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("toId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.TEACHER.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public CommentAudit getLessonCommentAudit(Long lessonId, Long orgId, Boolean isSystem) {
        List result;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.count("id", "num");
        builder.sum("score", "totalScoce");
        builder.eq("lessonId", (Serializable)lessonId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.queryList(builder, CommentAudit.class)))) {
            return (CommentAudit)result.get(0);
        }
        return null;
    }

    @Override
    public List<CommentAudit> getLessonsCommentAudit(Collection<Long> lessonIds, Long orgId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.count("id", "num");
        builder.group("lessonId");
        builder.sum("score", "totalScore");
        builder.in("lessonId", lessonIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        builder.eq("isSystem", (Serializable)Boolean.valueOf(false));
        return this.queryList(builder, CommentAudit.class);
    }

    @Override
    public CommentAudit getCommentAudit(Collection<Long> lessonIds, Long orgId, Boolean isSystem) {
        List result;
        if (CollectionUtils.isEmpty(lessonIds)) {
            return new CommentAudit();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.sum("score", "totalScore");
        builder.in("lessonId", lessonIds);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.queryList(builder, CommentAudit.class)))) {
            return (CommentAudit)result.get(0);
        }
        return new CommentAudit();
    }

    @Override
    public Map<Long, Integer> getLessonCommentCountMap(Collection<Long> lessonIds, final Long orgId, final Long fromId, final Long toId, final Integer userRole, Boolean isSystem) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonCommentDaoImpl.this.createSqlBuilder(new String[]{"lessonId"});
                builder.count("id", "num");
                builder.group("lessonId");
                builder.in("lessonId", querySet);
                builder.eq("userRole", (Serializable)userRole);
                builder.eq("orgId", (Serializable)orgId);
                if (fromId != null) {
                    builder.eq("fromId", (Serializable)fromId);
                }
                if (toId != null) {
                    builder.eq("toId", (Serializable)toId);
                }
                final Map result = Maps.newHashMap();
                OrgLessonCommentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("lessonId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgLessonComment> getStudentComments(Long orgId, Long userId, Integer userRole, Boolean isFrom, Boolean isSystem, Collection<Long> lessonIds, PageDto pageDto, String ... queryPorps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPorps);
        builder.eq("orgId", (Serializable)orgId);
        if (isFrom.booleanValue()) {
            builder.eq("fromId", (Serializable)userId);
        } else {
            builder.eq("toId", (Serializable)userId);
        }
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.in("lessonId", lessonIds);
        builder.eq("userRole", (Serializable)userRole);
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentLessonCommentCount(Long orgId, Long userId, Boolean isSystem) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("fromId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (isSystem != null) {
            builder.eq("isSystem", (Serializable)isSystem);
        }
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<Long> getCommentLessonIdsOfStudent(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"lessonId"});
        builder.eq("fromId", (Serializable)userId);
        builder.eq("userRole", (Serializable)Integer.valueOf(UserRole.STUDENT.getRole()));
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, List<Long>> getLessonCommentStudentMap(Collection<Long> lessonIds, final Boolean isSystem) {
        ListBatchQueryTemplate batch = new ListBatchQueryTemplate();
        List list = (List)batch.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgLessonComment>>(){

            public List<OrgLessonComment> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgLessonCommentDaoImpl.this.createSqlBuilder(new String[]{"lessonId", "fromId"});
                builder.in("lessonId", querySet);
                if (isSystem != null) {
                    builder.eq("isSystem", (Serializable)isSystem);
                }
                return OrgLessonCommentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)list, (Function)new Function<OrgLessonComment, Long>(){

            public Long apply(OrgLessonComment arg0) {
                return arg0.getLessonId();
            }
        }, (Function)new Function<OrgLessonComment, Long>(){

            public Long apply(OrgLessonComment arg0) {
                return arg0.getFromId();
            }
        });
    }
}

