/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseRoomDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseRoom>
implements OrgCourseRoomDao {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseRoomDaoImpl.class);

    public OrgCourseRoomDaoImpl() {
        super(OrgCourseRoom.class);
    }

    @Override
    public List<OrgCourseRoom> getCourseRoomList(Long orgId, Long courseId, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryList(builder);
    }

    @Override
    public List<Long> getCourseRoomIds(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, List<OrgCourseRoom>> getCourseRoomMap(final Long orgId, Collection<Long> courseIds, final String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        List courseRooms = (List)new ListBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseRoom>>(){

            public List<OrgCourseRoom> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseRoomDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                return OrgCourseRoomDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.group((Collection)courseRooms, (Function)new Function<OrgCourseRoom, Long>(){

            public Long apply(OrgCourseRoom input) {
                return input.getCourseId();
            }
        });
    }

    @Override
    public OrgCourseRoom getCourseDefaultRoom(Long orgId, Long courseId, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("isDefault", (Serializable)Boolean.valueOf(true));
        return (OrgCourseRoom)this.uniqueResult(builder);
    }

    @Override
    public List<OrgCourseRoom> getCourseDefaultRoom(final Long orgId, Collection<Long> courseIds, final String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseRoom>>(){

            public List<OrgCourseRoom> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseRoomDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("courseId", querySet);
                return OrgCourseRoomDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public int delCourseRoom(Long orgId, Long courseId, Collection<Long> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("room id is empty ,skip delete course rooms");
            return 0;
        }
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (courseId != null) {
            builder.eq("courseId", (Serializable)courseId);
        }
        builder.in("roomId", roomIds);
        return this.delete(builder);
    }

    @Override
    public void courseDefaultRoomSet(Long orgId, Long courseId, Long roomId, boolean enable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        Map<String, Boolean> updateCondition = Maps.newHashMap();
        updateCondition.put("orgId", (Boolean)((Object)orgId));
        updateCondition.put("courseId", (Boolean)((Object)courseId));
        updateCondition.put("roomId", (Boolean)((Object)roomId));
        OrgCourseRoom po = new OrgCourseRoom();
        po.setIsDefault(enable);
        int result = this.update(updateCondition, po, new String[]{"isDefault"});
        if (enable && result > 0) {
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.eq("orgId", (Serializable)orgId);
            builder.eq("courseId", (Serializable)courseId);
            builder.ne("roomId", (Serializable)roomId);
            builder.eq("isDefault", (Serializable)Boolean.valueOf(true));
            updateCondition = builder.collectConditionValue();
            updateCondition.put("isDefault", false);
            String sql = builder.toUpdateSql(new String[]{"isDefault"});
            log.debug("update other to false sql:{},update params:{}", (Object)sql, updateCondition);
            this.getNamedJdbcTemplate().update(sql, updateCondition);
        }
    }

    @Override
    public Map<Long, Integer> getCourseRoomCount(final Long orgId, Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseRoomDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.group("courseId");
                final HashMap result = Maps.newHashMap();
                OrgCourseRoomDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }
}

