/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgClassLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgClassLesson>
implements OrgClassLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgClassLessonDaoImpl.class);

    public OrgClassLessonDaoImpl() {
        super(OrgClassLesson.class);
    }

    @Override
    public List<OrgClassLesson> queryLessons(Long orgId, Collection<Long> courseIds, Collection<Long> roomIds, Collection<Long> lessonIds, Date startTime, Date endTime, PageDto page, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("courseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(roomIds)) {
            builder.in("roomId", roomIds);
        }
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            builder.in("id", lessonIds);
        }
        builder.asc("startTime");
        if (startTime != null) {
            builder.gt("startTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.desc("startTime");
            builder.lt("startTime", (Serializable)endTime);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getLessonTimemap(Collection<Long> courseIds, Date date, Long orgId, Integer delStatus) {
        List<OrgClassLesson> lessons = this.getLessons(courseIds, date, orgId, delStatus, "courseId");
        if (CollectionUtils.isEmpty(lessons)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgClassLesson orgClassLesson : lessons) {
            if (!map.containsKey(orgClassLesson.getCourseId())) {
                map.put(orgClassLesson.getCourseId(), 0);
            }
            map.put(orgClassLesson.getCourseId(), (Integer)map.get(orgClassLesson.getCourseId()) + 1);
        }
        return map;
    }

    @Override
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, final Date date, final Long orgId, final Integer delStatus, final String ... queryProps) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)delStatus);
                builder.in("courseId", querySet);
                if (date != null) {
                    builder.le("endTime", (Serializable)date);
                }
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgClassLesson> getLessons(Collection<Long> courseIds, final Date startTime, final Date endTime, PageDto pageDto) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("courseId", querySet);
                if (startTime != null) {
                    builder.ge("startTime", (Serializable)startTime);
                }
                if (endTime != null) {
                    builder.lt("startTime", (Serializable)endTime);
                }
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<Long> getLeftLessonIds(Long orgId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("courseId", (Serializable)courseId);
        builder.ge("startTime", (Serializable)new Date());
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Integer getLessonCountOfStudent(Long orgId, Long courseId, Long studentId) {
        String sql = "select count(ocl.id) from tts.org_class_lesson ocl join tts.org_student_lesson osl on osl.lesson_id = ocl.id where osl.student_id = :studentId and ocl.course_id = :courseId and ocl.org_id = :orgId";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("courseId", courseId);
        paramMap.put("studentId", studentId);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)paramMap, Integer.class);
    }

    @Override
    public int updateLessonClassRoom(Long orgId, Collection<Long> lessonIds, Long roomId) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return 0;
        }
        if (roomId == null) {
            roomId = 0L;
        }
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("roomId", roomId);
        params.put("lessonIds", lessonIds);
        String sql = "update tts.org_class_lesson set room_id=:roomId where orgId=:orgId and id in :lessonIds ";
        log.debug("update lesson sql:{} params:{}", (Object)sql, (Object)params);
        return this.getNamedJdbcTemplate().update(sql, (Map)params);
    }

    @Override
    public void batchUpdateLessonNumber(Map<String, ?>[] lessonIdNumberMaps) {
        if (ArrayUtils.isEmpty((Object[])lessonIdNumberMaps)) {
            return;
        }
        String sql = "update tts.org_class_lesson set number=:number where  id=:id ";
        log.debug("sql:{} batch update params:{}", (Object)sql, lessonIdNumberMaps);
        this.getNamedJdbcTemplate().batchUpdate(sql, (Map[])lessonIdNumberMaps);
    }

    @Override
    public Map<Long, Integer> getFinishLessonCount(Long orgId, Collection<Long> courseIds, final Integer delStatus) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        final Date now = new Date();
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.group("courseId");
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.le("endTime", (Serializable)now);
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Integer> getLessonCount(Long orgId, Collection<Long> courseIds, final Integer delStatus) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(new String[]{"courseId"});
                builder.count("id", "num");
                builder.in("courseId", querySet);
                builder.group("courseId");
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<OrgClassLesson> getLessonByCourseId(Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        return this.queryList(builder, OrgClassLesson.class);
    }

    @Override
    public Map<Long, OrgClassLesson> getClassLessonMap(final Long orgId, Collection<Long> lessonIds, final Integer delStatus, final String ... props) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        List list = (List)batchQueryTemplate.batchQuery(lessonIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgClassLesson>>(){

            public List<OrgClassLesson> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgClassLessonDaoImpl.this.createSqlBuilder(props);
                builder.in("id", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)delStatus);
                return OrgClassLessonDaoImpl.this.queryList(builder);
            }
        });
        HashMap map = Maps.newHashMap();
        for (OrgClassLesson po : list) {
            map.put(po.getId(), po);
        }
        return map;
    }

    @Override
    public Integer getFinishLessonCount(Long orgId, Long courseId, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.eq("courseId", (Serializable)courseId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.le("endTime", (Serializable)new Date());
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getLessonCount(Long orgId, Long courseId, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.eq("courseId", (Serializable)courseId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgClassLesson> querylessonsByEndTime(Date startTime, Date endTime, Integer delStatus, PageDto pageDto) {
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"startTime is null!");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.gt("courseId", (Serializable)Integer.valueOf(0));
        builder.ge("endTime", (Serializable)startTime);
        builder.lt("endTime", (Serializable)endTime);
        builder.desc("endTime");
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getCourseLessonCount(Long orgId, Collection<Long> courseIds, Long studentId, Long teacherId, Date endTime) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        final StringBuilder sb = new StringBuilder();
        final HashMap params = Maps.newHashMap();
        sb.append("select lesson.course_id AS courseId, count(lesson.id) AS num from tts.org_class_lesson lesson ");
        if (studentId != null) {
            sb.append("join tts.org_student_lesson student on lesson.id = student.lesson_id ");
            params.put("studentId", studentId);
        }
        if (teacherId != null) {
            sb.append("join tts.org_teacher_lesson teacher on lesson.id = teacher.lesson_id ");
            params.put("teacherId", teacherId);
        }
        sb.append("where lesson.org_id=:orgId and lesson.course_id in (:courseIds) ");
        if (studentId != null) {
            sb.append("and student.student_id =:studentId ");
        }
        if (teacherId != null) {
            sb.append("and teacher.teacher_id =:teacherId ");
        }
        if (endTime != null) {
            sb.append("and lesson.end_time <=:endTime ");
            params.put("endTime", endTime);
        }
        params.put("orgId", orgId);
        sb.append("group by lesson.course_id ");
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                params.put("courseIds", querySet);
                final HashMap result = Maps.newHashMap();
                OrgClassLessonDaoImpl.this.getNamedJdbcTemplate().query(sb.toString(), params, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("courseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<Long> filterLessonListByTime(Collection<Long> courseIds, Collection<Long> lessonIds, Date date) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.in("id", lessonIds);
        builder.in("courseId", courseIds);
        builder.le("endTime", (Serializable)date);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgClassLesson> getLeftRoomIdLessons(Long orgId, Long roomId, Date startTime, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("roomId", (Serializable)roomId);
        if (startTime != null) {
            builder.gt("startTime", (Serializable)startTime);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Long> getOrgLessonIds(Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("startTime");
        return this.queryForList(builder, Long.class);
    }
}

