
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.signup.dao;

import java.util.Date;

import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;


/**
 * @title OrgSignupOnlinePayDao
 * @desc TODO
 * @author cxm
 * @date 2015年10月26日
 * @version 1.0
 */

public interface OrgSignupOnlinePayDao extends CommonDao<OrgSignupOnlinePay> {
    /**
     * 免登陆查看订单信息的附加加密KEY
     */
    String ENC_KEY = "TTS_SIGNUP_KEY";

    String SIGNUP_PAY_SMS_CONTENT_TEMPLATE = "您正在报名『%s』的%s,费用%s元。点击链接完成缴费：%s";

    String SIGNUP_COMPLETE_SMS_CONTENT_TEMPLATE = "恭喜您成功报名『%s』的%s,费用%s元。点击链接查看报名凭证：%s";

    /**
     * 根據短信的唯一標誌獲取訂單信息
     * 
     * @param smsKey
     * @return
     */
    OrgSignupOnlinePay getBySmsKey(String smsKey, String...queryProps);

    /**
     * 获取最近的当前订单的短信记录
     * 
     * @param purchaseId
     * @param queryProps
     * @return
     */
    OrgSignupOnlinePay getLastRecordByPurchaseId(Long purchaseId, String...queryProps);

    /**
     * 根据订单ID和手机号查看发送的短信次数
     * 
     * @param purchaseId
     * @param mobile
     * @return
     */
    int countByMobileAndPurchaseId(Long purchaseId, String mobile, Date startTime);
}

    