/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title TtsSmsDao
 * @desc TODO
 * @author cxm
 * @date 2015年10月26日
 * @version 1.0
 */
public interface TtsSmsDao extends CommonDao<TtsSms> {
    /**
     * 机构发送短信数量
     * @param orgId
     * @param sender_role 发送用户类型 0:老师 2:学生 6:机构 可以为null
     * @param send_result 发送结果 0:待发送 1:成功 2:失败
     * @param startDate 可以为null
     * @param endDate 可以为null
     * @return
     */
    Integer getTtsSmsTotal(Integer orgId, Integer userRole, Integer sendResult, String startDate, String endDate);

    Map<Long,Integer> getOrgTtsSmsCount(Date startTime,Date endTime, List<Long> TianxiaoOrgIds);

}
