package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zhangrui
 * @version 1.0
 * @title OrgLessonConflictDao
 * @desc TODO
 */

public interface OrgLessonConflictDao extends CommonDao<OrgLessonConflict> {

    public boolean updateLessonConflictByCondition(Long orgId,Map<String,Object> fileds,Map<String,Object> condition);

    List<OrgLessonConflict> queryTeacherLessonConflict(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId, PageDto pageDto);


    /**
     * 查询有冲突的课节
     * @param orgId：机构id
     * @param teacherIds：老师id集合
     * @param courseIds：教室集合id
     * @return
     */
	public List<OrgLessonConflict> queryConfilctByTeacherIds(Long orgId, List<Long> teacherIds);

	/**
	 * 查询冲突课节
	 * @param orgId：机构id
	 * @param classRoomIds：教室id集合
	 * @param courseIds：课程id集合
	 * @return
	 */
	public List<OrgLessonConflict> queryConfilctByClassRoomIds(Long orgId, List<Long> classRoomIds);

    List<OrgLessonConflict> queryRoomLessonConflict(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId, PageDto pageDto);

    int queryTeacherConflictNum(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId);

    int queryRoomConflictNum(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId);

	void updateDelStatus(Set<Object> id);

	void saveOrgLessonConflicts(List<OrgLessonConflict> lists);
}
